package com.hupu.tv.player.app.ui.presenter

import android.widget.TextView
import com.hupu.tv.player.app.BuildConfig
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.HostUrl
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.contact.NickNameActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper
import okhttp3.MediaType
import okhttp3.MultipartBody
import okhttp3.RequestBody
import org.greenrobot.eventbus.EventBus
import java.io.File

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class NickNameActivityPresenter : IBasePresenter, NickNameActivityContact.Present {
    private var mView: NickNameActivityContact.Display? = null
    private var mTvMessage: TextView? = null
    private var list: ArrayList<AdBean>? = arrayListOf()
    override fun attachView(view: IBaseDisplay?) {
        mView = view as NickNameActivityContact.Display?
    }

    override fun detachView() {
        list = null
        mTvMessage = null
    }

    override fun login(phone: String, nickName: String, smsCode: String, userAvatar: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["channelId"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["nickName"] = nickName
        hashMap["smsCode"] = smsCode
        hashMap["phone"] = phone
        hashMap["userAvatar"] = userAvatar
        mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求login地址${SPUtil[Constants.HOST_URL, HostUrl.HOST_URL] as String + HostUrl.POST_LOGIN}\n请求login参数$hashMap "
        RetrofitClient.retrofitService
                .loginLive(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {

                        UserHelper.userLoginSaveToken(data)
                        getUserInfo(phone)
                    }

                    override fun onError(t: Throwable) {
                        mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求login失败${t.message}"
                        super.onError(t)
                        WaitDialog.dismiss()
                    }
                })
    }

    override fun startNext() {
        MainActivity.start(mView?.ctx!!)
        mView?.baseActivity?.finish()
    }

    override fun setTextView(tvMessage: TextView) {
        mTvMessage = tvMessage
    }

    override fun uploadFile(filePath: String?) {
        val file = File(filePath)
        val imageBody = RequestBody.create(MediaType.parse("multipart/form-data"), file)
        //添加文件(file就是你服务器中需要的文件参数)
        val part = MultipartBody.Part.createFormData("file", file.name, imageBody)
        RetrofitClient.retrofitService
                .uploadFile(part)
                .compose(NetworkTransformer(mView ))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        mView?.onAvatarSuccess(SPUtil[Constants.AVATAR_URL, ""] as String + data)

                    }
                })
    }

    private fun getUserInfo(phone: String) {
        RetrofitClient.retrofitService
                .getUserInfo()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LiveUserBean>() {
                    override fun onSuccess(data: LiveUserBean?) {
                       UserHelper.userLoginSuccessForPhone(data,phone)
                        mView?.onLoginRequest()
                    }
                })
    }

}