package com.hupu.tv.player.app.ui.presenter

import android.content.Intent
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.lds.ui.webView.WebViewActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.PayCommonTypeBean
import com.hupu.tv.player.app.bean.PayInfoBean
import com.hupu.tv.player.app.bean.PayTypeBean
import com.hupu.tv.player.app.ui.contact.PayInfoContract
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/24
 * @describe
 */
class PayInfoPresenter : IBasePresenter, PayInfoContract.Presenter {
    private var mView: PayInfoContract.DisPlay? = null
    private var list: ArrayList<PayInfoBean> = arrayListOf()
    override fun attachView(view: IBaseDisplay?) {
        mView = view as PayInfoContract.DisPlay?
    }

    override fun detachView() {

    }

    override fun gePayTypeData() {
        RetrofitClient.retrofitService
                .getVipType()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<PayTypeBean>>() {
                    override fun onSuccess(data: List<PayTypeBean>?) {
                        data?.forEach {
                            when (it.payChannel) {
                                Constants.AILI_PAY -> {
                                    it.iconUrl = R.mipmap.icon_pay_test_zfb
                                }
                                Constants.WX_PAY -> {
                                    it.iconUrl = R.mipmap.icon_pay_test_wx
                                }
                            }
                        }
                        mView?.onRequestList(data)
                    }
                })
    }

    override fun getResult() {
        val hashMap = HashMap<String, Int>()
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getPayResult(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {

                    }
                })
    }

    override fun payVip(channelId: Int, vipLevelId: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["payChannelId"] = channelId
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        hashMap["id"] = vipLevelId
        hashMap["payType"] = vipLevelId
        RetrofitClient.retrofitService
                .payVip(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.baseActivity?.startActivity(CommonUtils.toWeb(data
                                ?: "http://www.baidu.com"))
//                        val intent = Intent(mView?.baseActivity, WebViewActivity::class.java)
//                        intent.putExtra(Constants.H5_URL, data)
//                        intent.putExtra(Constants.H5_URL_TYPE, Constants.TYPE_TEXT)
//                        mView?.baseActivity?.startActivity(intent)
                    }
                })
    }

    override fun pay(channelId: Int, id: Int, payType: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["payChannelId"] = channelId
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        hashMap["id"] = id
        hashMap["payType"] = payType
        RetrofitClient.retrofitService
                .pay(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<PayCommonTypeBean>() {
                    override fun onSuccess(data: PayCommonTypeBean?) {
                        if (data?.payType == Constants.PAY_TYPE_HTML) {
                            val intent = Intent(mView?.baseActivity, WebViewActivity::class.java)
                            intent.putExtra(Constants.H5_URL, data.result)
                            intent.putExtra(Constants.H5_URL_TYPE, Constants.TYPE_TEXT)
                            mView?.baseActivity?.startActivity(intent)
                        } else {
                            mView?.baseActivity?.startActivity(CommonUtils.toWeb(data?.result))
                        }
                    }
                })
    }

    override fun payCoin(channelId: Int, id: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["payChannelId"] = channelId
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .payCoin(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
//                        val parse = Jsoup.parse(data)
//                        mView?.baseActivity?.startActivity(CommonUtils.toWeb(data
//                                ?: "http://www.baidu.com"))
                        val intent = Intent(mView?.baseActivity, WebViewActivity::class.java)
                        intent.putExtra(Constants.H5_URL_TYPE, Constants.TYPE_TEXT)
                        intent.putExtra(Constants.H5_URL, data)
                        mView?.baseActivity?.startActivity(intent)
                    }
                })
    }
}