package com.hupu.tv.player.app.ui.presenter

import android.annotation.SuppressLint
import android.content.Intent
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.BindPhoneActivity
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.activity.ShareActivity
import com.hupu.tv.player.app.ui.contact.PlayerDetailContact
import com.hupu.tv.player.app.utils.JsonUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/6/24
 * @describe
 */
class PlayerDetailPresenter : IBasePresenter, PlayerDetailContact.Presenter {
    private var mView: PlayerDetailContact.Display? = null
    companion object{
        const val REQUEST_BIND_PHONE=1
    }
    override fun attachView(view: IBaseDisplay?) {
        mView = view as PlayerDetailContact.Display?
    }

    override fun detachView() {

    }

    override fun getMovieDetail(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieDetailBean>() {
                    override fun onSuccess(data: MovieDetailBean?) {
                        mView?.onRequestMoveDetail(data)
                    }
                })
    }


    override fun getRecommend() {
        val hashMap = HashMap<String, Any>()
        hashMap["sortTag"] = 2
        hashMap["pageNo"] = 1
        hashMap["pageSize"] = 200
        hashMap["guessLike"] = true
        RetrofitClient.retrofitService
                .getSortMovieList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        mView?.onRequestRecommend(data)

                    }
                })
    }

    override fun getLike() {
        val hashMap = HashMap<String, Any>()
        hashMap["sortTag"] = 2
        hashMap["pageNo"] = 1
        hashMap["pageSize"] = 30
        hashMap["guessLike"] = true
        RetrofitClient.retrofitService
                .getSortMovieList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        data?.records.let {
                            mView?.onLikeMovie(it as ArrayList<MovieBean.RecordsBean>?)
                        }

                    }
                })
    }

    @SuppressLint("CheckResult")
    override fun moviePlay(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .playMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<PlayMovieBean>() {
                    override fun onSuccess(data: PlayMovieBean?) {
//                        if (BuildConfig.DEBUG) {
//                            ToastUtil.l(
//                                    "播放电影接口：movie/moviePlay " +
//                                            "\n 参数：movieId=$movieId,userId=${SPUtil[Constants.USER_ID, 0]}" +
//                                            "\n请求成功data?.statusMessage=${data?.statusMessage}")
//
//                        }
                        refreshUserBean()
                        mView?.onPlayerMovie()

                    }
                })

    }

    override fun goShare() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, ShareActivity::class.java))
    }

    override fun clickLike(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .likeMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LikeBean>() {
                    override fun onSuccess(data: LikeBean?) {
                        mView?.onLikeRefresh(data?.nums ?: 0)
                        ToastUtil.s(data?.statusMessage)
                    }
                })
    }

    override fun clickCollect(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .collectMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LikeBean>() {
                    override fun onSuccess(data: LikeBean?) {
//                        if (BuildConfig.DEBUG) {
//                            ToastUtil.l(
//                                    "收藏电影接口：movie/collection " +
//                                            "\n 参数：movieId=$movieId,userId=${SPUtil[Constants.USER_ID, 0]}" +
//                                            "\n请求成功，结果：data?.statusMessage:${data?.statusMessage}")
//                        }
                        mView?.onCollectionRefresh(data?.nums ?: 0)
                        ToastUtil.s(data?.statusMessage)
//                        EventBus.getDefault().post(RefreshVisibleEvent(Constants.COLLECTION))
                    }
                })
    }

    override fun shareMovie() {
        mView?.onShareMovie(SPUtil[Constants.SHARE_LINK,""] as String)
    }

    override fun downloadMovie(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .downloadMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        refreshUserBean()
                        mView?.onDownloadMovie()
                    }
                })
    }

    /**
     * 如果是未看视频，处理成已看
     */
    override fun dealDownloadWatch(bean: MovieBean.RecordsBean) {
        if (bean.localUrl != null && bean.localUrl.isNotEmpty()) {
            val list = SPUtil.getSerializableObject<ArrayList<MovieBean.RecordsBean>>(Constants.DOWNLOAD)
            list?.forEach {
                if (bean.localUrl == it.localUrl) {
                    it.isWatch = true
                }
            }
            SPUtil.putSerializableObject(Constants.DOWNLOAD, list)
        }
    }

    override fun refreshUserBean() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE,""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<UserBean>() {
                    override fun onSuccess(data: UserBean?) {
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        SPUtil.put(Constants.USER_ID, data?.id)
                        EventBus.getDefault().post(RefreshUserEvent())
                    }
                })
    }

    override fun goBindPhone() {
        val baseActivity: BaseActivity<*>? = mView as BaseActivity<*>
        val intent = Intent(baseActivity, BindPhoneActivity::class.java)
        baseActivity?.startActivityForResult(intent,REQUEST_BIND_PHONE)
    }

    override fun getRefreshMovieDetail(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieDetailBean>() {
                    override fun onSuccess(data: MovieDetailBean?) {
                        mView?.onRefreshMovieDetail(data)
                    }
                })
    }

    override fun shareMineInfo() {
        mView?.onShareMineInfo()
    }

    override fun goVip() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineBuyVipActivity::class.java))
    }

    override fun getWinnerList() {
        RetrofitClient.retrofitService
                .getWinnerList()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<String>>() {
                    override fun onSuccess(data: List<String>?) {
                        mView?.onWinnerRequest(data)
                    }
                })
    }

    override fun buyGold(movieId: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .buyMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onBuyResult()
                    }

//                    override fun onFinish() {
//                        super.onFinish()
//                        mView?.onBuyResult()
//                    }
                })
    }
}