package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.PromotionListBean
import com.hupu.tv.player.app.ui.contact.PromotionListFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/29
 * @describe
 */
class PromotionListFragmentPresenter : IBasePresenter, PromotionListFragmentContact.Presenter {
    private var mView: PromotionListFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as PromotionListFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getPromotionList(topId: Int, navigateId: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap[Constants.TOP_ID] = topId
        hashMap[Constants.NAVIGATE_ID] = navigateId
        RetrofitClient.retrofitService
                .getPromotionList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<PromotionListBean>>() {
                    override fun onSuccess(data: List<PromotionListBean>?) {
                        mView?.onRequestList(data as ArrayList<PromotionListBean>?)
                    }
                })
    }


}