package com.hupu.tv.player.app.ui.presenter

import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.RedDetailEntity
import com.hupu.tv.player.app.bean.RedListEntity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.ui.contact.RedDetailContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class RedDetailPresenter : IBasePresenter, RedDetailContact.Presenter {
    private var mView: RedDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as RedDetailContact.Display
    }

    override fun detachView() {

    }

    override fun getDetail(id: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getRedDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<RedDetailEntity?>() {
                    override fun onSuccess(data: RedDetailEntity?) {
                        mView?.onDetail(data)
                    }
                })
    }

    override fun getAssociate(id: Int, pageNum: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        hashMap["pageNum"] = pageNum
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getRedAssociate(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<RedListEntity?>() {
                    override fun onSuccess(data: RedListEntity?) {
                        mView?.onAssociate(data?.dataList)
                    }
                })
    }

    override fun focus(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .focusExpert(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<Any?>() {
                override fun onSuccess(data: Any?) {
                    mView?.onFocus()
                }
            })
    }

    override fun cancelFocus(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .cancelFocusExpert(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<Any?>() {
                override fun onSuccess(data: Any?) {
                    mView?.onCancelFocus()
                }
            })

    }
}