package com.hupu.tv.player.app.ui.presenter


import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.contact.RegisterActivityContact
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class RegisterActivityPresenter : IBasePresenter, RegisterActivityContact.Present {
    private var mView: RegisterActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as RegisterActivityContact.Display?
    }

    override fun detachView() {
    }

    override fun register(phone: String, nickName: String, smsCode: String, password: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["channelId"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["nickName"] = nickName
        hashMap["smsCode"] = smsCode
        hashMap["phone"] = phone
        hashMap["password"] = password
        RetrofitClient.retrofitService
            .register(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    CommonUtils.umengRegisterEvent()
                    UserHelper.userLoginSaveToken(data)
                    getUserInfo(phone)
                }
            })
    }


    override fun startNext() {
        MainActivity.start(mView?.ctx!!)
        mView?.baseActivity?.finish()
    }

    override fun getSmsCode(phone: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
            .getSmsCode(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                }

            })
    }

    private fun getUserInfo(phone: String) {
        RetrofitClient.retrofitService
            .getUserInfo()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<LiveUserBean>() {
                override fun onSuccess(data: LiveUserBean?) {
                    UserHelper.userLoginSuccessForPhone(data, phone)
                    mView?.onRegister()
                }
            })
    }


}