package com.hupu.tv.player.app.ui.presenter

import android.text.TextUtils
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.SearchTagBean
import com.hupu.tv.player.app.bean.SpecialBallBean
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.contact.SearchSpecialistActivityContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/5
 * @describe
 */
class SearchSpecialistActivityPresenter : IBasePresenter, SearchSpecialistActivityContact.Presenter {
    private var mView: SearchSpecialistActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SearchSpecialistActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun searchData(key: String?, save: Boolean, pageNo: Int) {
        if (!TextUtils.isEmpty(key)) {
            val hashMap = HashMap<String, Any>()
            hashMap["searchContent"] = key!!
            hashMap["pageNum"] = pageNo
            hashMap["pageSize"] = 10
            RetrofitClient.retrofitService
                    .specialistSearch(JsonUtils.toRequestBody(hashMap))
                    .compose(NetworkTransformer(mView))
                    .subscribe(object : RxCallback<SpecialBallBean>() {
                        override fun onSuccess(data: SpecialBallBean?) {
                        mView?.onSearchData(data?.dataList)
                            if (save) {
                                saveLocalSearchData(key)
                            }
                        }
                    })
        }
    }


    override fun clearLocalData() {
        val arrayListOf = arrayListOf<String>()
        SPUtil.putSerializableObject(Constants.SEARCH_KEYWORD_RED, arrayListOf)
        mView?.updateLocalData(arrayListOf)
    }

    override fun showLocalData() {
        val list = SPUtil.getSerializableObject<ArrayList<String>>(Constants.SEARCH_KEYWORD_RED)
        mView?.onShowLocalData(list)
    }

    override fun getHotTag() {
        RetrofitClient.retrofitService
                .getSearchTag()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<SearchTagBean>>() {
                    override fun onSuccess(data: List<SearchTagBean>?) {
                        mView?.onHotList(data as ArrayList<SearchTagBean>)
                    }
                })
    }

    private fun saveLocalSearchData(key: String) {
        var list = SPUtil.getSerializableObject<ArrayList<String>>(Constants.SEARCH_KEYWORD_RED)
        if (list == null || list.isEmpty()) {
            val newList = arrayListOf<String>()
            newList.add(key)
            SPUtil.putSerializableObject(Constants.SEARCH_KEYWORD_RED, newList)
            list = newList
        } else {
            var containt = false
            run outside@{
                list.forEach {
                    if (key == it) {
                        containt = true
                        return@outside
                    } else {
                        containt = false
                    }
                }
            }
            if (!containt) {
                list.add(key)
            }
            SPUtil.putSerializableObject(Constants.SEARCH_KEYWORD_RED, list)
        }
        mView?.updateLocalData(list)
    }


}



