package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.FileUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.SeeMoreDownloadActivityContact

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class SeeMoreDownloadActivityPresenter : IBasePresenter, SeeMoreDownloadActivityContact.Presenter {
    private var mView: SeeMoreDownloadActivityContact.DisPlay? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SeeMoreDownloadActivityContact.DisPlay?
    }

    override fun detachView() {

    }

    override fun getMovieDownload() {
        val allList = SPUtil.getSerializableObject<ArrayList<MovieBean.RecordsBean>>(Constants.DOWNLOAD)
        if (allList == null || allList.isEmpty()) {
            mView?.onRequestMovieDownloadList(null)
            mView?.onRequestMovieDownloadFinishList(null)
        }
        val downloadNowList = arrayListOf<MovieBean.RecordsBean>()
        val downloadNowFinishList = arrayListOf<MovieBean.RecordsBean>()
        allList?.forEach { it ->
            if (it.isDownloadFinish) {
                downloadNowFinishList.add(it)
            } else {
                downloadNowList.add(it)
            }
        }
        mView?.onRequestMovieDownloadList(downloadNowList)
        mView?.onRequestMovieDownloadFinishList(downloadNowFinishList)
    }

    override fun deleteMovie(list:ArrayList<MovieBean.RecordsBean>) {
        val allList = SPUtil.getSerializableObject<ArrayList<MovieBean.RecordsBean>>(Constants.DOWNLOAD)
        val currentIterator = list.iterator()
        //如果需要删除的元素有的话
        while (currentIterator.hasNext()) {
            //如果当前元素相同的话，删除
            val spIterator = allList?.iterator()
            val currentBean = currentIterator.next()
            val currentUrl = currentBean.videoFullUrl
            while (spIterator?.hasNext() == true){
                //再判断所有集合里面是否有
                val spBean = spIterator.next()
                val videoUrl = spBean.videoFullUrl
                if (videoUrl == currentUrl) {
                    FileUtil.deleteFolderFile(spBean.localUrl,true)
                    spIterator.remove()
                    currentIterator.remove()

                }
            }
        }

        SPUtil.putSerializableObject(Constants.DOWNLOAD,allList)
        getMovieDownload()
    }
}