package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.SeeMoreHistoryActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import java.util.*
import kotlin.collections.HashMap

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class SeeMoreHistoryActivityPresenter : IBasePresenter, SeeMoreHistoryActivityContact.Presenter {
    private var mView: SeeMoreHistoryActivityContact.DisPlay? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SeeMoreHistoryActivityContact.DisPlay?
    }

    override fun detachView() {

    }

    override fun getMovieHistory(pageNo: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        hashMap["id"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieHistory(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        mView?.onRequestMovieHistoryList(data?.records as ArrayList<MovieBean.RecordsBean>)
                    }
                })
    }




}