package com.hupu.tv.player.app.ui.presenter


import android.util.Log
import android.widget.TextView
import com.hupu.tv.player.app.BuildConfig
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.HostUrl
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.contact.ForgetPasswordActivityContact
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.ui.contact.SettingPasswordActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class SettingPasswordActivityPresenter : IBasePresenter, SettingPasswordActivityContact.Present {
    private var mView: SettingPasswordActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SettingPasswordActivityContact.Display?
    }

    override fun detachView() {
    }



    override fun settingPassword(password: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["pwd"] = password
        RetrofitClient.retrofitService
            .settingPassword(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSettingPassword()
                }

            })
    }


}