package com.hupu.tv.player.app.ui.presenter


import android.widget.ProgressBar
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.UpdateEntity
import com.hupu.tv.player.app.ui.contact.SettingContact
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper
import com.kongzue.dialog.v3.CustomDialog
import com.softgarden.baselibrary.utils.ToastUtil
import com.xuexiang.xupdate.XUpdate
import com.xuexiang.xupdate._XUpdate
import com.xuexiang.xupdate.service.OnFileDownloadListener
import java.io.File
import kotlin.math.roundToInt

/**
 * @author by Dell
 * @date on 2021/3/12
 * @describe
 */
class SettingPresenter : IBasePresenter, SettingContact.presenter {
    private var mView: SettingContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SettingContact.Display?
    }

    override fun detachView() {

    }


    override fun exitLogin() {
        RetrofitClient.retrofitService
            .loginOut()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    UserHelper.userExitLoginSuccess()
                    mView?.onExit()
                }
            })
    }

    override fun destroyUser() {
        RetrofitClient.retrofitService
            .destroyUser()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    UserHelper.userExitLoginSuccess()
                    mView?.onExit()
                }
            })
    }

    override fun checkVersion() {
        RetrofitClient.retrofitService
            .checkVersion(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("clientName", "android")
                put("version", BuildConfig.VERSION_NAME)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<UpdateEntity>() {
                override fun onSuccess(data: UpdateEntity?) {
                    val remoteVersion = data?.version?.split(".")
                    if (remoteVersion?.size ?: 0 == 3) {
                        val localVersion = BuildConfig.VERSION_NAME.split(".")
                        remoteVersion?.let {
                            if (it[2].toInt() > localVersion[2].toInt() || it[1].toInt() > localVersion[1].toInt() || it[0].toInt() > localVersion[0].toInt()) {
                                mView?.onCheckVersion(true, data)
                            } else {
                                mView?.onCheckVersion(false, data)
                            }
                        }
                    }
                }
            })
    }

    fun update(entity: UpdateEntity?) {
//        it.adress = "https://oss.ucdl.pp.uc.cn/fs01/union_pack/Wandoujia_2963029_web_seo_baidu_binded.apk?x-oss-process=udf%2Fpp-udf%2CJjc3LiMnJ3V%2Fd3d3dA%3D%3D"
        val appCompatActivity = mView as AppCompatActivity
        DialogUtils.showUpDateApp(
            appCompatActivity,
            entity?.introduction ?: "",
            entity?.forceUpdate ?: false,
            entity?.version.orEmpty(),
            object : DialogUtils.OnUpdateClickListener {
                override fun onLeftClick(dialog: CustomDialog?) {
                    if (entity?.forceUpdate == true) {
                        dialog?.doDismiss()
                    }
                    dialog?.doDismiss()
                }

                override fun onRightClick(
                    view: TextView?,
                    progressBar: ProgressBar?,
                    dialog: CustomDialog?
                ) {
                    XUpdate.newBuild(appCompatActivity)
                        .apkCacheDir(appCompatActivity.filesDir.path) //设置下载缓存的根目录
                        .build()
                        .download(
                            entity?.downloadLink,
                            object : OnFileDownloadListener {
                                //设置下载的地址和下载的监听
                                override fun onStart() {
                                }

                                override fun onProgress(progress: Float, total: Long) {
                                    val intProgress = (progress * 100).roundToInt()
                                    view?.text = "$intProgress%"
                                    progressBar?.progress = intProgress
                                }

                                override fun onCompleted(file: File): Boolean {
                                    _XUpdate.startInstallApk(appCompatActivity, file)
//                                    ToastUtil.s("apk下载完毕，文件路径：" + file.path)
                                    return false
                                }

                                override fun onError(throwable: Throwable) {
                                    if (entity?.forceUpdate == true) {
                                        ToastUtil.s("apk下载失败，即将退出应用，请前往官网下载新版本")
                                        view?.postDelayed({
//                                        BaseDialog.unload()
                                            dialog?.doDismiss()
//                                            appCompatActivity.finish()
                                        }, 2000)
                                    } else {
                                        view?.postDelayed({
//                                        BaseDialog.unload()
                                            dialog?.doDismiss()
                                        }, 1000)
                                        ToastUtil.s("apk下载失败，请前往官网下载新版本")
                                    }

                                }
                            })
                }
            })
    }
}

