package com.hupu.tv.player.app.ui.presenter

import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.RedDetailEntity
import com.hupu.tv.player.app.bean.RedListEntity
import com.hupu.tv.player.app.bean.SpecialistDetailEntity
import com.hupu.tv.player.app.ui.contact.MaterialDetailContact
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.ui.contact.RedDetailContact
import com.hupu.tv.player.app.ui.contact.SpecialistDetailContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class SpecialistDetailPresenter : IBasePresenter, SpecialistDetailContact.Presenter {
    private var mView: SpecialistDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SpecialistDetailContact.Display
    }

    override fun detachView() {

    }


    override fun focus(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .focusExpert(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<Any?>() {
                override fun onSuccess(data: Any?) {
                    mView?.onFocus()
                }
            })
    }

    override fun cancelFocus(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .cancelFocusExpert(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<Any?>() {
                override fun onSuccess(data: Any?) {
                    mView?.onCancelFocus()
                }
            })

    }

    override fun getSpecialistDetail(id: String) {
        RetrofitClient.retrofitService
            .getSpecialistDetail(JsonUtils.toRequestBody(HashMap<String, Any>().apply {
                put("id", id)
            }))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<SpecialistDetailEntity?>() {
                override fun onSuccess(data: SpecialistDetailEntity?) {
                    mView?.onDetail(data)
                }
            })
    }
}