package com.hupu.tv.player.app.ui.presenter

import android.widget.TextView
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.contact.SplashActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.VersionControl

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class SplashActivityPresenter : IBasePresenter, SplashActivityContact.Presenter {
    private var mView: SplashActivityContact.Display? = null
    private var mTvMessage: TextView? = null
    private var list: ArrayList<AdBean>? = arrayListOf()
    override fun attachView(view: IBaseDisplay?) {
        mView = view as SplashActivityContact.Display?
    }

    override fun detachView() {
        list = null
        mTvMessage = null
    }

    override fun startNext() {
        MainActivity.start(mView?.ctx!!)
        mView?.baseActivity?.finish()
    }

    override fun setTextView(tvMessage: TextView) {
        mTvMessage = tvMessage
    }

    override fun getMainBanner() {
        RetrofitClient.retrofitService
            .getBannerList(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("adType", 8)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<ArrayList<BannerBean>>() {
                override fun onSuccess(data: ArrayList<BannerBean>?) {
                    SPUtil.putSerializableObject(Constants.MAIN_BANNER, data)
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求广告成功"
                    getConfig()
                }
            })
    }



    private fun getConfig() {
        RetrofitClient.retrofitService
            .getLiveConfig()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<ShowConifgEntity>() {
                override fun onSuccess(data: ShowConifgEntity?) {
                    VersionControl.saveConfig(data?.show?:false)
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求控制成功"
                    getBannerList()
                }
            })
    }

    override fun getBannerList() {
        RetrofitClient.retrofitService
            .getBannerList(JsonUtils.toRequestBody(hashMapOf<String, Any>()))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<ArrayList<BannerBean>>() {
                override fun onSuccess(data: ArrayList<BannerBean>?) {
                    SPUtil.putSerializableObject(Constants.BANNER_LIST, data)
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求Banner成功"
                    getNewsList()
                }
            })
    }

    override fun addDownNum() {
        RetrofitClient.retrofitService
            .addDownNum()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<Any>() {
                override fun onSuccess(data: Any?) {

                }
            })
    }

    private fun getNewsList() {
        RetrofitClient.retrofitService
            .getNewsHeadList(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("type", 2)
            }))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<List<BannerBean>>() {
                override fun onSuccess(data: List<BannerBean>?) {
                    SPUtil.putSerializableObject(Constants.NEWS_HEAD_LIST, data)
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求HeadList成功"
                    getShareConfig()
                }
            })
    }

    private fun getShareConfig() {
        RetrofitClient.retrofitService
            .getShareConfig()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<ShareBean>() {
                override fun onSuccess(data: ShareBean?) {
                    SPUtil.putSerializableObject(Constants.COMMON_SHARE_BEAN, data)
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求shareConfig成功"
                    mView?.onAvatarUrlRequest()
                }
            })
    }


}