package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.StarDetailActivityContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class StarDetailActivityPresenter : IBasePresenter, StarDetailActivityContact.Present {
    private var mView: StarDetailActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as StarDetailActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun getDetail(id: Int,mPage:Int) {
        val hashMap = HashMap<String, Any?>()
        hashMap["id"] = id
        hashMap["pageNo"] = mPage
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMovieStarDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<StarDetailBean>() {
                    override fun onSuccess(data: StarDetailBean?) {
                        mView?.onDetail(data)
                    }
                })

    }


}