package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.StarBean
import com.hupu.tv.player.app.ui.contact.StarFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/29
 * @describe
 */
class StarFragmentPresenter :IBasePresenter, StarFragmentContact.Presenter{
    private var mView:StarFragmentContact.Display?=null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as StarFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getStar(sign:String?,pageNo:Int) {
        val hashMap = HashMap<String, Any?>()
        hashMap["sign"] = sign
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMovieStarList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<StarBean>() {
                    override fun onSuccess(data: StarBean?) {
                        mView?.onStarResponse(data?.list)
                    }
                })
    }




}