package com.hupu.tv.player.app.ui.presenter

import android.content.Intent
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.activity.MineWalletActivity
import com.hupu.tv.player.app.ui.activity.ShareActivity
import com.hupu.tv.player.app.ui.contact.TikTokActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2021/1/30
 * @describe
 */
class TikTokActivityPresenter : IBasePresenter, TikTokActivityContact.Presenter {
    private var mView: TikTokActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as TikTokActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun getFindTikTokMovieList(mPage: Int, alreadyPage: Int, list: List<MovieBean.RecordsBean>?) {
        if (mPage == alreadyPage) {
            mView?.onDataResponse(list)
        } else {
            val hashMap = HashMap<String, Any>()
            hashMap["pageNo"] = mPage
            hashMap["pageSize"] = 10
            hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
            RetrofitClient.retrofitService
                    .getTikTokFindList(JsonUtils.toRequestBody(hashMap))
                    .compose(NetworkTransformer(mView))
                    .subscribe(object : RxCallback<MainTagBean>() {
                        override fun onSuccess(data: MainTagBean?) {
                            mView?.onDataResponse(data?.dataList)
                        }
                    })
        }

    }

    override fun getStartTikTokMovieList(mPage: Int, key: Int, alreadyPage: Int, list: List<MovieBean.RecordsBean>?) {
        if (mPage == alreadyPage) {
            mView?.onDataResponse(list)
        } else {
            val hashMap = HashMap<String, Any?>()
            hashMap["id"] = key
            hashMap["pageNo"] = mPage
            hashMap["pageSize"] = 10
            RetrofitClient.retrofitService
                    .getMovieStarDetail(JsonUtils.toRequestBody(hashMap))
                    .compose(NetworkTransformer(mView))
                    .subscribe(object : RxCallback<StarDetailBean>() {
                        override fun onSuccess(data: StarDetailBean?) {
                            data?.let {
                                mView?.onDataResponse(data.movies)
                            }
                        }
                    })
        }

    }

    override fun getTikTokMovieList(mPage: Int, key: String, alreadyPage: Int, list: List<MovieBean.RecordsBean>?) {
        if (mPage == alreadyPage) {
            mView?.onDataResponse(list)
        } else {
            val hashMap = HashMap<String, Any>()
            hashMap["UserId"] = SPUtil[Constants.USER_ID, 0] as Int
            hashMap["tagName"] = key
            hashMap["pageNo"] = mPage
            hashMap["pageSize"] = 10
            RetrofitClient.retrofitService
                    .getMovieListByTag(JsonUtils.toRequestBody(hashMap))
                    .compose(NetworkTransformer(mView))
                    .subscribe(object : RxCallback<MainTagBean>() {
                        override fun onSuccess(data: MainTagBean?) {
                            data?.dataList.let {
                                mView?.onDataResponse(it)
                            }
                        }
                    })
        }

    }

    override fun getMovieDetail(movieId: Int?, position: Int) {
        LogUtils.e("viewPagerLayout movieDetail position:$position")
        if (movieId == null) {
            return
        }
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<MovieDetailBean>() {
                    override fun onSuccess(data: MovieDetailBean?) {
                        LogUtils.e("viewPagerLayout onData position:$position")
                        mView?.onRequestMoveDetail(data, position)
                    }
                })
    }


    override fun clickCollect(movieId: Int?, position: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .collectMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<LikeBean>() {
                    override fun onSuccess(data: LikeBean?) {
                        mView?.onCollectionRefresh(data?.nums ?: 0, position)
//                        ToastUtil.s(data?.statusMessage)
                    }
                })
    }

    override fun moviePlay(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .playMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<PlayMovieBean>() {
                    override fun onSuccess(data: PlayMovieBean?) {
                        refreshUserBean()
                        mView?.onPlayerMovie()
                    }
                })

    }


    fun refreshUserBean() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE, ""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<UserBean>() {
                    override fun onSuccess(data: UserBean?) {
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        SPUtil.put(Constants.USER_ID, data?.id)
                        EventBus.getDefault().post(RefreshUserEvent())
                    }
                })
    }

    override fun getWinnerList() {
        val hashMap = HashMap<String, Any>()
        hashMap["type"] = 1
        RetrofitClient.retrofitService
                .getWinnerListParam(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<List<String>>() {
                    override fun onSuccess(data: List<String>?) {
                        mView?.onWinnerRequest(data)
                    }
                })
    }

    override fun goShare() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, ShareActivity::class.java))
    }

    override fun goVip() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineBuyVipActivity::class.java))
    }

    override fun goWallet() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineWalletActivity::class.java))
    }


}