package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.ui.contact.UserFeedBackContact

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class UserFeedBackPresenter : IBasePresenter, UserFeedBackContact.Presenter {
    private var mView: UserFeedBackContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as UserFeedBackContact.Display
    }

    override fun detachView() {

    }




    override fun getFeedBackList() {
        RetrofitClient.retrofitService
                .getFeedBackList()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onFeedBackList()
                    }
                })
    }
}