package com.hupu.tv.player.app.ui.presenter


import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.UserInfoContact
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper
import okhttp3.MediaType
import okhttp3.MultipartBody
import okhttp3.RequestBody
import org.greenrobot.eventbus.EventBus
import java.io.File

/**
 * @author by Dell
 * @date on 2021/3/12
 * @describe
 */
class UserInfoPresenter : IBasePresenter, UserInfoContact.presenter {
    private var mView: UserInfoContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as UserInfoContact.Display?
    }

    override fun detachView() {

    }


    override fun editInfo(nickName: String, sex: Int, birthday: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["description"] = ""
        hashMap["nickName"] = nickName
        hashMap["sex"] = sex
        hashMap["birthday"] = birthday
        RetrofitClient.retrofitService
            .editUser(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    getUserInfo()
                }
            })
    }

    override fun uploadFile(filePath: String?) {
        val file = File(filePath)
        val imageBody = RequestBody.create(MediaType.parse("multipart/form-data"), file)
        //添加文件(file就是你服务器中需要的文件参数)
        val part = MultipartBody.Part.createFormData("file", file.name, imageBody)
        RetrofitClient.retrofitService
            .uploadFile(part)
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                    editAvatar(data ?: "")

                }
            })
    }


    private fun editAvatar(avatarUrl: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["avatarUrl"] = avatarUrl
        RetrofitClient.retrofitService
            .editUserAvatar(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    SPUtil.put(Constants.AVATAR_URL, data)
                    getUserInfo()
                }
            })
    }


    private fun getUserInfo() {
        RetrofitClient.retrofitService
            .getUserInfo()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<LiveUserBean>() {
                override fun onSuccess(data: LiveUserBean?) {
                    UserHelper.userLoginSuccess(data)
                    mView?.onSuccess()
                }
            })
    }
}