package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.ui.contact.UserToFeedBackContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class UserToFeedBackPresenter : IBasePresenter, UserToFeedBackContact.Presenter {
    private var mView: UserToFeedBackContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as UserToFeedBackContact.Display
    }

    override fun detachView() {

    }

    override fun getFeedBackType() {
//        RetrofitClient.retrofitService
//                .getFeedBackTypeList()
//                .compose(NetworkTransformer(mView))
//                .subscribe(object : RxCallback<String>() {
//                    override fun onSuccess(data: String?) {
//                        mView?.onFeedBack()
//                    }
//                })

    }


    override fun feedBack(contactDetails: String, feedbackImg: String, feedbackText: String, id: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["contactDetails"] = contactDetails
        hashMap["feedbackImg"] = feedbackImg
        hashMap["feedbackText"] = feedbackText
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .feedBack(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onFeedBack()
                    }
                })
    }


}