package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.WalletDetailBean
import com.hupu.tv.player.app.ui.contact.WalletDetailContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/29
 * @describe
 */
class WalletDetailPresenter : IBasePresenter, WalletDetailContact.Presenter {
    private var mView: WalletDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as WalletDetailContact.Display
    }

    override fun detachView() {

    }

    override fun getWalletDetail(pageNo: Int) {
        val hashMap = HashMap<String, Int>()

        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getWalletDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<WalletDetailBean>() {
                    override fun onSuccess(data: WalletDetailBean?) {
                        mView?.onRequest(data?.dataList)
                    }
                })
    }
}