package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.WithdrawInfoBean
import com.hupu.tv.player.app.ui.contact.WithdrawInfoContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/29
 * @describe
 */
class WithdrawInfoPresenter : IBasePresenter, WithdrawInfoContact.Presenter {
    private var mView: WithdrawInfoContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as WithdrawInfoContact.Display
    }

    override fun detachView() {

    }


    override fun withDraw(amount: Int, bankName: String, cardName: String, cardNo: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        hashMap["amount"] = amount
        hashMap["bankName"] = bankName
        hashMap["cardName"] = cardName
        hashMap["cardNo"] = cardNo
        RetrofitClient.retrofitService
                .withdraw(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<WithdrawInfoBean>() {
                    override fun onSuccess(data: WithdrawInfoBean?) {
                        ToastUtil.s(data?.msg)
                        mView?.withDrawSuccess()
                    }
                })
    }
}