package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.WithdrawBean
import com.hupu.tv.player.app.ui.contact.WithdrawContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/29
 * @describe
 */
class WithdrawPresenter : IBasePresenter, WithdrawContact.Presenter {
    private var mView: WithdrawContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as WithdrawContact.Display
    }

    override fun detachView() {

    }

    override fun getWithDraw() {
        val hashMap = HashMap<String, Int>()
        hashMap["userId"]= SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .checkWithdraw(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<WithdrawBean>(){
                    override fun onSuccess(data: WithdrawBean?) {
                        mView?.onRequest(data)
                    }
                })
    }
}