package com.hupu.tv.player.app.ui.testMvp

import android.content.Context
import android.content.Intent
import android.view.View
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.ToolbarActivity
import com.hupu.tv.player.app.bean.ImageBean

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 * 1.这里要泛型 要记得写上当前Presenter  要继承view的接口Contract.Display
 */
class TestMvpActivity<P:IBasePresenter> : ToolbarActivity<TestMvpPresenter?>() {
    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return builder.setTitle("MVP模板")
    }

    override val layoutId: Int
        get() = R.layout.activity_test_mvp

    override val baseActivity: BaseActivity<*>?
        get() = this

    override val ctx: Context?
        get() = this

    override fun initialize() {
        /**
         * 2.调用 多种方式任选
         */
        presenter?.indexData?.subscribe(object : RxCallback<List<ImageBean?>?>() {
            override fun onSuccess(data: List<ImageBean?>?) {}
        })
        presenter?.indexData?.subscribe({ goodsBeans: List<ImageBean?>? -> }) { throwable: Throwable -> showError(throwable) }
    }

    fun onClick(view: View?) {
        ToastUtil.s(getString(R.string.app_name))
        //  ActivityManager.getInstance().finishAfter(MainActivity.class);
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, TestMvpActivity::class.java)
            //        starter.putExtra();
            context.startActivity(starter)
        }
    }
}