package com.hupu.tv.player.app.ui.testRefresh

import android.content.Context
import android.content.Intent
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.BaseRVHolder
import com.softgarden.baselibrary.base.SelectedAdapter
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.ImageBean
import com.hupu.tv.player.app.utils.ImageUtil

class TestRefreshActivity : RefreshActivity<TestRefreshPresenter?>() {
    private var mAdapter: SelectedAdapter<ImageBean>? = null

    override val layoutId: Int
        get() = R.layout.activity_test_refresh

    override val baseActivity: BaseActivity<*>?
        get() = this
    override val ctx: Context?
        get() = this


    override fun initialize() {
        initRefreshLayout()
        initRecyclerView()
        mAdapter = object : SelectedAdapter<ImageBean>(R.layout.item_images) {
            override fun onBindVH(holder: BaseRVHolder, data: ImageBean, position: Int) {
                ImageUtil.load(holder.getView(R.id.ivImage), data.url)
            }
        }
        mAdapter?.setSelectMode(true)
        mRecyclerView!!.adapter = mAdapter
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return builder.setTitle("上拉刷新，下拉加载")
    }

    override fun loadData() {
        presenter!!.getData2(mPage, PAGE_COUNT).subscribe(object : RxCallback<List<ImageBean?>?>() {
            override fun onSuccess(data: List<ImageBean?>?) {
                setLoadMore(mAdapter!!, data)
            }
        })
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, TestRefreshActivity::class.java)
            //        starter.putExtra();
            context.startActivity(starter)
        }
    }
}