package com.hupu.tv.player.app.utils

import android.graphics.Bitmap
import androidx.appcompat.app.AppCompatActivity

import com.softgarden.baselibrary.utils.RxPermissionsUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.app.Constants

/**
 * @author by Dell
 * @date on 2020/7/25
 * @describe
 */

object AppUtils{
    fun showMineVipCard(activity: AppCompatActivity, title:String){
        CommonUtils.copy(SPUtil[Constants.SHARE_LINK, ""] as String)
        ToastUtil.s("分享链接已经复制到剪切板")
        DialogUtils.showMineQrCode(activity ,title, object : DialogUtils.OnClickSaveBitmapListener {
            override fun onClick(bitmap: Bitmap?) {
                RxPermissionsUtil.check(activity, RxPermissionsUtil.STORAGE, "保存相册", object : RxPermissionsUtil.OnPermissionRequestListener {
                    override fun onSucceed() {
                        bitmap?.let {
                            val saveImageToGallery = ImageSaveUtil.saveBitmap(it, "ldshen${(Math.random() * 900 + 100).toInt()}")
                            if (saveImageToGallery) {
                                ToastUtil.s("保存成功")
                            } else {
                                ToastUtil.s("保存失败")
                            }
                        }
                    }
                    override fun onFailed() {
                        ToastUtil.s("保存功能需要开启权限")
                    }
                })
            }
        })
    }



}