package com.hupu.tv.player.app.utils

import android.annotation.SuppressLint
import android.app.Activity
import android.content.*
import android.content.pm.PackageManager
import android.graphics.Color
import android.media.Image
import android.net.Uri
import android.provider.DocumentsContract
import android.provider.MediaStore
import android.text.Spannable
import android.text.SpannableString
import android.text.TextUtils
import android.text.style.ForegroundColorSpan
import android.text.style.URLSpan
import android.text.util.Linkify
import android.util.Log
import android.view.View
import android.view.WindowManager
import android.widget.ImageView
import android.widget.TextView
import androidx.core.graphics.drawable.DrawableCompat
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.App
import com.hupu.tv.player.app.app.App.Companion.instance
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MovieBean.RecordsBean
import com.hupu.tv.player.app.utils.DateUtil.unitFormat
import com.hupu.tv.player.app.widget.LinkTextView
import com.hyphenate.util.UriUtils.*
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.SPUtil.Companion.getSerializableObject
import com.softgarden.baselibrary.utils.SPUtil.Companion.putSerializableObject
import com.softgarden.baselibrary.utils.ToastUtil
import com.softgarden.baselibrary.utils.ToastUtil.Companion.s
import com.umeng.analytics.MobclickAgent
import java.io.Serializable
import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*

/**
 * @author by Dell
 * @date on 2020/7/3
 * @describe
 */
object CommonUtils {
    @JvmStatic
    fun toWeb(url: String?): Intent {
        var url = url
        val intent = Intent()
        intent.action = Intent.ACTION_VIEW
        val isHttp = url?.startsWith("http") ?: false
        val uri: Uri
        if (TextUtils.isEmpty(url)) {
            url = "https://hszb.vip"
        }
        uri = if (isHttp) {
            Uri.parse(url)
        } else {
            Uri.parse("http://$url")
        }
        intent.data = uri
        return intent
    }


    @SuppressLint("UseCompatLoadingForDrawables")
    fun drawableTint(res:Int, color:String, view:View){
        val drawable = App.instance!!.resources.getDrawable(res)
        val wrap = DrawableCompat.wrap(drawable)
        DrawableCompat.setTint(wrap,Color.parseColor(color))
        if (view is ImageView){
            view.setImageDrawable(wrap)
        }else{
            view.background = wrap
        }
    }

    /**
     * 获取十六进制的颜色代码.例如  "#5A6677"
     * 分别取R、G、B的随机值，然后加起来即可
     *
     * @return String
     */
    fun getRandColor(): String {
        var R: String
        var G: String
        var B: String
        val random = Random()
        R = Integer.toHexString(random.nextInt(256)).uppercase(Locale.getDefault())
        G = Integer.toHexString(random.nextInt(256)).uppercase(Locale.getDefault())
        B = Integer.toHexString(random.nextInt(256)).uppercase(Locale.getDefault())
        R = if (R.length == 1) "0$R" else R
        G = if (G.length == 1) "0$G" else G
        B = if (B.length == 1) "0$B" else B
        return "#$R$G$B"
    }


    fun setNumberData(number: Int?): String? {
        var collection = "0"
        collection = number?.toString() ?: "0"
        number?.let {
            if (it > 10000) {
                collection = String.format("%.1f", it.toFloat() / 10000) + "W"
                return collection
            }
        }
        return collection
    }

    /**
     * 保持屏幕常亮
     */
    fun keepScreenLongLightOn(activity: Activity) {
        val window = activity.window
        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
    }

    /**
     * 关闭屏幕常亮
     */
    fun keepScreenLongLightOff(activity: Activity) {
        val window = activity.window
        window.clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
    }

    /**
     * 获取年
     *
     * @return
     */
    val year: Int
        get() {
            val cd = Calendar.getInstance()
            return cd[Calendar.YEAR]
        }

    /**
     * 获取当前的年月日
     */
    @JvmStatic
    val time: String
        get() {
            val format = SimpleDateFormat("yyyy-MM-dd", Locale.CHINA)
            return format.format(Calendar.getInstance().time)
        }

    /**
     * 获取指定日期
     *
     * @param i 0为今天，正整数则往后加
     * @return
     */
    fun getAppointDate(i: Int): String {
        var date = Date()
        val formatter = SimpleDateFormat("yyyy-MM-dd", Locale.CHINA)
        val calendar: Calendar = GregorianCalendar()
        calendar.time = date
        var dateString = ""
        try {
            calendar.add(Calendar.DATE, i) //把日期往后增加一天.整数往后推,负数往前移动
            date = calendar.time //这个时间就是日期往后推一天的结果
            dateString = formatter.format(date)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return dateString
    }

    fun getAppointDateMd(i: Int): String {
        var date = Date()
        val formatter = SimpleDateFormat("MM-dd", Locale.CHINA)
        val calendar: Calendar = GregorianCalendar()
        calendar.time = date
        var dateString = ""
        try {
            calendar.add(Calendar.DATE, i) //把日期往后增加一天.整数往后推,负数往前移动
            date = calendar.time //这个时间就是日期往后推一天的结果
            dateString = formatter.format(date)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return dateString
    }

    fun getCalendarWeek(dates: String): String {
        val calendar = Calendar.getInstance()
        val simpleDateFormat = SimpleDateFormat("yyyy-MM-dd")
        calendar.time = simpleDateFormat.parse(dates)
        return when (calendar.get(Calendar.DAY_OF_WEEK)) {
            1 -> "周日"
            2 -> "周一"
            3 -> "周二"
            4 -> "周三"
            5 -> "周四"
            6 -> "周五"
            7 -> "周六"
            else -> ""
        }
    }

    fun getWithCurrentDayDifferent(dates: String): Int {
        return dates.split("-").toTypedArray()[2].toInt() - currentDay
    }

    fun getCurrentDifferDay(dates: String): Int {
        var differDays = 0
        val split = dates.split("-").toTypedArray()
        val month = Integer.valueOf(split[1])
        val day = Integer.valueOf(split[2])
        //当前的返回的天数，大于当天的天数，而且保证了续签，一定是跨了月份
        return if (month > month) {
            if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
                differDays = day + 31
            }
            if (month == 2) {
                differDays = day + 28
            }
            if (month == 4 || month == 6 || month == 9 || month == 11) {
                differDays = day + 30
            }
            differDays - day
        } else {
            day - currentDay
        }
    }

    /**
     * 获取月
     *
     * @return
     */
    val month: Int
        get() {
            val cd = Calendar.getInstance()
            return cd[Calendar.MONTH] + 1
        }

    /**
     * 获取日
     *
     * @return
     */
    val currentDay: Int
        get() {
            val cd = Calendar.getInstance()
            return cd[Calendar.DATE]
        }

    /**
     * 获取时
     *
     * @return
     */
    val hour: Int
        get() {
            val cd = Calendar.getInstance()
            return cd[Calendar.HOUR]
        }

    /**
     * 获取分
     *
     * @return
     */
    val minute: Int
        get() {
            val cd = Calendar.getInstance()
            return cd[Calendar.MINUTE]
        }

    /**
     * 复制
     *
     * @param content
     */
    fun copy(content: String?) {
        val cm = instance!!.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
        // 创建普通字符型ClipData
        val mClipData = ClipData.newPlainText("Label", content)
        // 将ClipData内容放到系统剪贴板里。
        cm.setPrimaryClip(mClipData)
    }

    /**
     * 复制
     *
     * @param content
     */
    fun copy(content: String?, hint: String) {
        val cm = instance!!.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
        // 创建普通字符型ClipData
        val mClipData = ClipData.newPlainText("Label", content)
        // 将ClipData内容放到系统剪贴板里。
        cm.setPrimaryClip(mClipData)
        ToastUtil.s(hint)
    }

    fun toWeChat(): Intent {
        try {
            val intent = Intent(Intent.ACTION_MAIN)
            val cmp = ComponentName("com.tencent.mm", "com.tencent.mm.ui.LauncherUI")
            intent.addCategory(Intent.CATEGORY_LAUNCHER)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            intent.component = cmp
            return intent
        } catch (e: ActivityNotFoundException) {
            s("检查到您手机没有安装微信，请安装后使用该功能")
        }
        return Intent()
    }

    fun toQQ(): Intent? {
        return instance!!.packageManager.getLaunchIntentForPackage("com.tencent.mobileqq")
    }

    //    public static String getTopActivity(Context context){
    //        ActivityManager am = (ActivityManager) context.getSystemService(context.ACTIVITY_SERVICE);
    //        ComponentName cn = am.getRunningTasks(1).get(0).topActivity;
    //        Log.d("测试", "pkg:"+cn.getPackageName());//包名
    //        Log.d("测试", "cls:"+cn.getClassName());//包名加类名
    //        return cn.getClassName();
    //    }
    private fun getAppOpenIntentByPackageName(context: Context, packageName: String): Intent? {
        // MainActivity完整名
        var mainAct: String? = null
        // 根据包名寻找MainActivity
        val pkgMag = context.packageManager
        val intent = Intent(Intent.ACTION_MAIN)
        intent.addCategory(Intent.CATEGORY_LAUNCHER)
        intent.flags = Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED or Intent.FLAG_ACTIVITY_NEW_TASK
        @SuppressLint("WrongConstant") val list = pkgMag.queryIntentActivities(intent,
                PackageManager.GET_ACTIVITIES)
        for (i in list.indices) {
            val info = list[i]
            if (info.activityInfo.packageName == packageName) {
                mainAct = info.activityInfo.name
                break
            }
        }
        if (TextUtils.isEmpty(mainAct)) {
            return null
        }
        intent.component = ComponentName(context, packageName)
        return intent
    }

    private fun getPackageContext(context: Context, packageName: String): Context? {
        var pkgContext: Context? = null
        if (context.packageName == packageName) {
            pkgContext = context
        } else {
            // 创建第三方应用的上下文环境
            try {
                pkgContext = context.createPackageContext(packageName, Context.CONTEXT_IGNORE_SECURITY
                        or Context.CONTEXT_INCLUDE_CODE)
            } catch (e: PackageManager.NameNotFoundException) {
                e.printStackTrace()
            }
        }
        return pkgContext
    }

    fun openPackage(context: Context, packageName: String, toast: String?): Boolean {
        val pkgContext = getPackageContext(context, packageName)
        val intent = getAppOpenIntentByPackageName(context, packageName)
        if (pkgContext != null && intent != null) {
            pkgContext.startActivity(intent)
            return true
        } else {
            s(toast)
        }
        return false
    }//获取剪切板第一条内容

    /**
     * 获取剪切板内容
     *
     * @return
     */
    val clipBoard: String
        get() {
            val cm = instance!!.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
            val data = cm.primaryClip
            if (data != null) {
                //获取剪切板第一条内容
                val item: ClipData.Item? = data.getItemAt(0)
                return item?.text?.toString() ?: ""
            }
            return ""
        }

    //转成分钟和小时
    @JvmStatic
    fun formatTimeS(seconds: Long): String {
        var temp = 0
        val sb = StringBuffer()
        //大于一个小时
        if (seconds > 3600) {
            temp = (seconds / 3600).toInt()
            sb.append(if (seconds / 3600 < 10) "0$temp:" else "$temp:")
        }
        temp = (seconds % 3600 / 60).toInt()
        changeSeconds(seconds, temp, sb)
        return sb.toString()
    }

    private fun changeSeconds(seconds: Long, temp: Int, sb: StringBuffer) {
        var temp = temp
        sb.append(if (temp < 10) "0$temp:" else "$temp:")
        temp = (seconds % 3600 % 60).toInt()
        sb.append(if (temp < 10) "0$temp" else "" + temp)
    }

    fun saveDownloadList(beans: ArrayList<RecordsBean>?) {
        putSerializableObject(Constants.DOWNLOAD, beans)
    }

    val downloadList: ArrayList<RecordsBean>
        get() = getSerializableObject<Serializable>(Constants.DOWNLOAD) as ArrayList<RecordsBean>

    /**
     * @param time       需要判断的日期 毫秒
     * @param compareDay 需要判断大于或者小于多少(需要小于一个月)
     */
    @JvmStatic
    fun CompareDate(time: String, compareDay: Int): Boolean {
        val date = Date(time.toLong())
        val simpleDateFormat = SimpleDateFormat("yyyy-MM-dd", Locale.CHINA)
        val format = simpleDateFormat.format(date)
        //        return getTime().compareTo(format) > 0;
        val ts = format.split("-").toTypedArray()
        val year = ts[0].toInt()
        val month = ts[1].toInt()
        val day = ts[2].toInt()
        //已经不是今年了
        if (year != year) {
            return true
        }
        if (month > month) {
            //超过一个月了
            if (month - month > 1) {
                return true
            }
            var days = 0
            if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
                days = day + 31
            }
            if (month == 2) {
                days = day + 28
            }
            if (month == 4 || month == 6 || month == 9 || month == 11) {
                days = day + 30
            }
            return days - day > compareDay
        }
        return day - day > compareDay
    }

    @JvmStatic
    fun formateData(time: String): String {
        val date = Date(time.toLong())
        val simpleDateFormat = SimpleDateFormat("yyyy-MM-dd", Locale.CHINA)
        return simpleDateFormat.format(date)
    }

    fun CompareDateFormat(time: String, compareDay: Int): Boolean {
        val split = time.split(" ").toTypedArray()
        val ts = split[0].split("-").toTypedArray()
        val year = ts[0].toInt()
        val month = ts[1].toInt()
        val day = ts[2].toInt()
        //已经不是今年了
        if (year != year) {
            return false
        }
        if (month > month) {
            //超过一个月了
            if (month - month > 1) {
                return true
            }
            var days = 0
            if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
                days = day + 31
            }
            if (month == 2) {
                days = day + 28
            }
            if (month == 4 || month == 6 || month == 9 || month == 11) {
                days = day + 30
            }
            return days - day > compareDay
        }
        return day - day > compareDay
    }

    @JvmStatic
    fun generateTime(position: Long): String {
        val totalSeconds = (position / 1000).toInt()
        val seconds = totalSeconds % 60
        val minutes = totalSeconds / 60 % 60
        val hours = totalSeconds / 3600
        return if (hours > 0) {
            String.format(Locale.US, "%02d:%02d:%02d", hours, minutes,
                    seconds)
        } else {
            String.format(Locale.US, "%02d:%02d", minutes, seconds)
        }
    }

    fun generateTimeMinutes(position: Long): String {
        val totalSeconds = (position / 1000).toInt()
        val seconds = totalSeconds % 60
        val minutes = totalSeconds / 60 % 60
        val hours = totalSeconds / 3600
        return if (hours > 0) {
            String.format(Locale.US, "%02d:%02d:%02d", hours, minutes,
                    seconds)
        } else {
            String.format(Locale.US, "%02d:%02d", minutes, seconds)
        }
    }

    /**
     * 将时间戳转为代表"距现在多久之前"的字符串
     *
     * @param timeStr 时间戳
     * @return
     */
    fun getStandardDate(timeStr: String): String {
        val sb = StringBuffer()
        val t = timeStr.toLong()
        val time = System.currentTimeMillis() - t * 1000
        val mill = Math.ceil(time / 1000.toDouble()).toLong() //秒前
        val minute = Math.ceil(time / 60 / 1000.0f.toDouble()).toLong() // 分钟前
        val hour = Math.ceil(time / 60 / 60 / 1000.0f.toDouble()).toLong() // 小时
        val day = Math.ceil(time / 24 / 60 / 60 / 1000.0f.toDouble()).toLong() // 天前
        if (day - 1 > 0) {
            sb.append(day.toString() + "天")
        } else if (hour - 1 > 0) {
            if (hour >= 24) {
                sb.append("1天")
            } else {
                sb.append(hour.toString() + "小时")
            }
        } else if (minute - 1 > 0) {
            if (minute == 60L) {
                sb.append("1小时")
            } else {
                sb.append(minute.toString() + "分钟")
            }
        } else if (mill - 1 > 0) {
            if (mill == 60L) {
                sb.append("1分钟")
            } else {
                sb.append(mill.toString() + "秒")
            }
        } else {
            sb.append("刚刚")
        }
        if (sb.toString() != "刚刚") {
            sb.append("前")
        }
        return sb.toString()
    }

    /**
     * 将时间戳转为代表"还剩多少天"的字符串
     *
     * @param timeStr 时间戳
     * @return
     */
    fun getDaysDate(timeStr: String?): String {
        val sb = StringBuffer()
        val times = getStringToDate(timeStr, "yyyy-MM-dd")
        val time = times - System.currentTimeMillis()
        val day = Math.ceil(time / 24 / 60 / 60 / 1000.0f.toDouble()).toLong() // 天前
        if (day >= 0) {
            sb.append(day.toString() + "天")
        }
        return sb.toString()
    }

    fun getStringToDate(dateString: String?, pattern: String?): Long {
        val dateFormat = SimpleDateFormat(pattern)
        var date = Date()
        try {
            date = dateFormat.parse(dateString)
        } catch (e: ParseException) {
            // TODO Auto-generated catch block
            e.printStackTrace()
        }
        return date.time
    }

    /**
     * 时间转换  秒转分
     */
    fun GetMinutes(s: Int): String? {
        var timeStr: String? = null
        var hour = 0L
        var minute = 0L
        var second = 0L
        minute = s.div(60L)
        if (minute < 60) {
            second = s % 60L
            timeStr = unitFormat(minute).toString() + ":" + unitFormat(second)
        } else {
            hour = minute / 60
            if (hour > 99) return ""
            minute %= 60
            second = s - hour * 3600 - minute * 60
            timeStr = unitFormat(hour).toString() + ":" + unitFormat(minute) + ":" + unitFormat(second)
        }
        return timeStr
    }


    fun linkText(content: String, textView: TextView): SpannableString {

        //注意：不要在xml配置android:autoLink属性
        val sp = SpannableString(content)
        //这句很重要，也可以添加自定义正则表达式
        Linkify.addLinks(sp, Linkify.WEB_URLS)
        //主要是获取span的位置
        val spans = sp.getSpans(0, content.length, URLSpan::class.java)
        //这里可以用过循环处理就可以动态实现文本颜色的差别化了
        //设置高亮样式一
        for (span in spans) {
            sp.setSpan(ForegroundColorSpan(instance!!.resources.getColor(R.color.web_blue)), sp.getSpanStart(span), sp.getSpanEnd(span), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        }
        textView.movementMethod = LinkTextView.LocalLinkMovementMethod.getInstance()
        return sp
    }

    open fun getRealPathFromUriAboveApiAndroidK(context: Context?, uri: Uri): String? {
        var filePath: String? = null
        if (DocumentsContract.isDocumentUri(context, uri)) {
            // 如果是document类型的 uri, 则通过document id来进行处理
            val documentId = DocumentsContract.getDocumentId(uri)
            if (isMediaDocument(uri)) {
                // 使用':'分割
                val id = documentId.split(":").toTypedArray()[1]
                val selection = MediaStore.Images.Media._ID + "=?"
                val selectionArgs = arrayOf(id)
                filePath = getDataColumn(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, selection, selectionArgs)
            } else if (isDownloadsDocument(uri)) {
                val contentUri = ContentUris.withAppendedId(Uri.parse("content://downloads/public_downloads"), java.lang.Long.valueOf(documentId))
                filePath = getDataColumn(context, contentUri, null, null)
            }
        } else if ("content".equals(uri.scheme, ignoreCase = true)) {
            // 如果是 content 类型的 Uri
            filePath = getDataColumn(context, uri, null, null)
        } else if ("file" == uri.scheme) {
            // 如果是 file 类型的 Uri,直接获取图片对应的路径
            filePath = uri.path
        }
        return filePath
    }

    fun umengLogin() {
        val deviceId = SPUtil[Constants.DEVICE_ID, ""] as String
        //当用户使用自有账号登录时，可以这样统计：
        MobclickAgent.onEvent(App.instance, "onLogin")
        MobclickAgent.onProfileSignIn(deviceId)
//        MobclickAgent.onPageStart(Constants.UMENG_LOGIN)

//当用户使用第三方账号（如新浪微博）登录时，可以这样统计：
//        MobclickAgent.onProfileSignIn("WB", "userID")

    }

    fun umengFirstOpen(){
        MobclickAgent.onEvent(instance,"onFirsOpen")
    }

    fun umengJoinLive(){
        MobclickAgent.onEvent(instance,"onOpenLIve")
    }

    fun umengRegisterEvent(){
        MobclickAgent.onEvent(instance,"onRegisterEvent")
    }

    fun umengCopyQQNumOrWxNum(){
        MobclickAgent.onEvent(instance,"onCopyQQNumOrWxNum")
    }


    fun umengLoginOut() {
        //登出
        Log.e("Umenglogin", "umengLoginOut")
        MobclickAgent.onEvent(App.instance, "onLoginOut")
//        MobclickAgent.onPageEnd(Constants.UMENG_LOGIN)
        MobclickAgent.onProfileSignOff()
    }


//    fun getTestDeviceInfo(context: Context?): Array<String?>? {
//        val deviceInfo = arrayOfNulls<String>(2)
//        try {
//            if (context != null) {
//                deviceInfo[0] = UMConfigure.getDeviceIdForGeneral(context)
//                deviceInfo[1] = DeviceConfig.getMac(context)
//                Log.e("umeng","device=${deviceInfo[0]},mac = ${deviceInfo[1]}")
//            }
//        } catch (e: java.lang.Exception) {
//        }
//        return deviceInfo
//    }

}