package com.hupu.tv.player.app.utils

import java.text.SimpleDateFormat

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object DateUtil {
    const val FORMAT_HMS = "HH:mm:ss"
    const val FORMAT_YMD = "yyyy-MM-dd"
    const val FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss"
    fun getDataStr(time: Long, format: String?): String {
        val formatter = SimpleDateFormat(format)
        return formatter.format(time)
    }

    /**
     * 整数转换为时分秒
     *
     * @param endTime
     * @return
     */
    // a integer to xx:xx:xx
    fun secToTimeStr(endTime: Long): String {
        var timeStr: String? = null
        var hour: Long = 0
        var minute: Long = 0
        var second: Long = 0
        if (endTime <= 0) return "00:00:00" else {
            minute = endTime / 60
            if (minute < 60) {
                second = endTime % 60
                timeStr = "00:" + unitFormat(minute) + ":" + unitFormat(second)
            } else {
                hour = minute / 60
                minute = minute % 60
                second = endTime - hour * 3600 - minute * 60
                timeStr = unitFormat(hour) + ":" + unitFormat(minute) + ":" + unitFormat(second)
            }
        }
        return timeStr
    }

    fun secToDayTime(secondTime: Long): String {
        var secondTime = secondTime
        val timeStr = StringBuilder()
        val day = secondTime / 86400
        secondTime = secondTime % 86400
        val hour = secondTime / 3600 % 24
        val min = secondTime / 60 % 60
        val second = secondTime % 60
        if (day > 0) {
            timeStr.append(day.toString() + "天")
            timeStr.append(hour.toString() + "时")
            timeStr.append(min.toString() + "分")
            timeStr.append(second.toString() + "秒")
        }
        return timeStr.toString()
    }

    /**
     * 为小于10的数补零
     *
     * @param i
     * @return
     */
    fun unitFormat(i: Long): String {
        var retStr: String? = null
        retStr = if (i >= 0 && i < 10) "0" + java.lang.Long.toString(i) else "" + i
        return retStr
    }
}