package com.hupu.tv.player.app.utils

import android.content.Intent
import android.graphics.Bitmap
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import android.widget.*
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.kongzue.dialog.util.BaseDialog
import com.kongzue.dialog.v3.BottomMenu
import com.kongzue.dialog.v3.CustomDialog
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.GiftEvent
import com.hupu.tv.player.app.ui.activity.LoginActivity
import com.hupu.tv.player.app.ui.adapter.GiftAdapter
import com.hupu.tv.player.app.ui.adapter.MatchLiveAdapter
import com.hupu.tv.player.app.ui.adapter.NewSignAdapter
import com.hupu.tv.player.app.widget.customIm.CustomCircleImageView
import org.greenrobot.eventbus.EventBus


/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
object DialogUtils {
    fun payVipDialog(activity: AppCompatActivity?, onClickListener: OnClickListener) {
        CustomDialog.show(activity, R.layout.pay_vip) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val left = v.findViewById<View>(R.id.tv_left)
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
                onClickListener.onLeftClick(left)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            val right = v.findViewById<View>(R.id.tv_right)
            right.setOnClickListener {
                onClickListener.onRightClick(right)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showGiftList(activity: AppCompatActivity?) {
        val list = SPUtil.getSerializableObject<ArrayList<GiftBean>>(Constants.GIFT_BEAN)
        if (list != null && list.size != 0) {
            CustomDialog.show(
                activity,
                R.layout.item_bottom_gift_menu
            ) { dialog: CustomDialog, v: View ->
                //                setViewBottom(dialog)
                var selectedGitfBean: GiftBean? = null
                var giftPosition = 0
                val liveUserBean =
                    SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)

                val tvSend = v.findViewById<TextView>(R.id.tv_send)
                val tvGold = v.findViewById<TextView>(R.id.tv_gold)
                tvGold.text = liveUserBean?.gold.toString()
                val recyclerView = v.findViewById<RecyclerView>(R.id.recycler_gift)

                recyclerView.layoutManager =
                    LinearLayoutManager(activity, RecyclerView.HORIZONTAL, false)
                val giftAdapter = GiftAdapter(R.layout.item_gift, list, activity)
                recyclerView.adapter = giftAdapter
                giftAdapter.bindToRecyclerView(recyclerView)
                giftAdapter.setOnItemClickListener { adapter, view, position ->
                    adapter.data.forEach {
                        val giftBean = it as GiftBean
                        giftBean.isSelect = false
                    }
                    val giftBean = adapter.getItem(position) as GiftBean
                    giftBean.isSelect = true
                    adapter.notifyItemRangeChanged(0, adapter.data.size, "refresh")
                    tvSend.isSelected = true
                    selectedGitfBean = giftBean
                    giftPosition = position
                }
                tvSend.setOnClickListener {
                    if (selectedGitfBean == null) {
                        ToastUtil.s("请选择要赠送的礼物")
                        return@setOnClickListener
                    }
                    if (liveUserBean?.gold ?: 0 >= selectedGitfBean?.gold ?: 0) {
                        EventBus.getDefault().post(
                            GiftEvent(
                                selectedGitfBean?.id
                                    ?: 0, giftPosition
                            )
                        )
                        dialog.doDismiss()
                    } else {
                        ToastUtil.s("金币不足，请努力加油")
                    }
                }

            }.align = BaseDialog.ALIGN.BOTTOM
        }
    }

    fun showAdDialog(activity: AppCompatActivity?){
        CustomDialog.show(activity, R.layout.ad_dialog) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val imageView = v.findViewById<ImageView>(R.id.iv_img)
            val main = SPUtil.getSerializableObject<ArrayList<BannerBean>>(Constants.MAIN_BANNER)
            if (main?.isNotEmpty() == true){
                GlideUtils.loadImage(activity,main[0].picPath, imageView)
            }
            imageView.setOnClickListener {
                activity?.startActivity(CommonUtils.toWeb(main?.get(0)?.adUrl))
                dialog.doDismiss()
            }

            v.findViewById<ImageView>(R.id.iv_close).setOnClickListener {
                dialog.doDismiss()
            }
        }
    }


    fun selectedSex(activity: AppCompatActivity?, onClickListener: OnClickListener) {
        val build =
            CustomDialog.build(activity, R.layout.selected_sex) { dialog: CustomDialog, v: View ->
                setView(dialog)
                val left = v.findViewById<View>(R.id.tv_left)
                v.findViewById<View>(R.id.tv_left).setOnClickListener {
                    onClickListener.onLeftClick(left)
//                BaseDialog.unload()
                    dialog.doDismiss()
                }
                val right = v.findViewById<View>(R.id.tv_right)
                right.setOnClickListener {
                    onClickListener.onRightClick(right)
//                BaseDialog.unload()
                    dialog.doDismiss()
                }
            }
        build.align = BaseDialog.ALIGN.BOTTOM
        build.show()
    }

    fun selectSex(activity: AppCompatActivity, onBottomMenuListener: OnBottomMenuListener) {
        val baseAdapter: BaseAdapter =
            ArrayAdapter(activity, R.layout.item_bottom_menu, listOf("保密", "男", "女"))
        BottomMenu.show(activity, baseAdapter) { text, index ->
            onBottomMenuListener.onclick(index, text)
        }
    }


    fun payCoinDialog(
        activity: AppCompatActivity?,
        buyGoldCoin: Int,
        onClickListener: OnClickListener
    ) {
        CustomDialog.show(activity, R.layout.pay_coin) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val left = v.findViewById<View>(R.id.tv_left)
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
                onClickListener.onLeftClick(left)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            activity?.let {
                val coin = it.getString(R.string.string_text_pay, buyGoldCoin)
                val style = SpannableStringBuilder(coin)
                style.setSpan(
                    ForegroundColorSpan(it.resources.getColor(R.color.bg_red_2)),
                    4,
                    4 + buyGoldCoin.toString().length,
                    SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                v.findViewById<TextView>(R.id.tv_content).text = style
            }

            val right = v.findViewById<View>(R.id.tv_right)
            right.setOnClickListener {
                onClickListener.onRightClick(right)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun payVipDownloadDialog(
        activity: AppCompatActivity?,
        tips: String?,
        onClickListener: OnClickListener
    ) {
        CustomDialog.show(activity, R.layout.pay_vip) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            tvContent.text = tips
            val left = v.findViewById<View>(R.id.tv_left)
            v.findViewById<View>(R.id.tv_left).setOnClickListener { v1: View? ->
                onClickListener.onLeftClick(left)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            val right = v.findViewById<View>(R.id.tv_right)
            right.setOnClickListener { v2: View? ->
                onClickListener.onRightClick(right)
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun bindPhoneDialog(
        activity: AppCompatActivity?,
        number: String?,
        onClickListener: OnClickSingleListener
    ) {
        CustomDialog.show(activity, R.layout.bind_phone) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            tvContent.text = number
            val left = v.findViewById<View>(R.id.tv_left)
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            val right = v.findViewById<View>(R.id.tv_right)
            right.setOnClickListener { v2: View? ->
                onClickListener.onClick()
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showMineQrCode(
        activity: AppCompatActivity?,
        title: String?,
        onClickListener: OnClickSaveBitmapListener
    ) {
        CustomDialog.show(activity, R.layout.show_mine_qr_code) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val userBean: UserBean? = SPUtil.getSerializableObject(Constants.USER_BEAN)
            val ivUserHead: CustomCircleImageView = v.findViewById(R.id.iv_user_head)
            val tvShareAddress = v.findViewById<TextView>(R.id.tv_share_address)
            val tvName = v.findViewById<TextView>(R.id.tv_name)
            val ivQrCode = v.findViewById<ImageView>(R.id.iv_qr_code)
            val tvMainTitle = v.findViewById<TextView>(R.id.tv_main_title)
            tvMainTitle.text = title
            userBean?.let {
                tvName.text = it.userName
                if (it.isVip == Constants.IS_VIP) {
                    ivUserHead.background =
                        activity?.resources?.getDrawable(R.mipmap.bg_icon_vip_head)
                } else {
                    ivUserHead.background = null
                    ivUserHead.setFrameColor(activity?.resources?.getColor(R.color.text_blue) ?: 0)
                }
            }
            val address = SPUtil[Constants.SHARE_LINK, ""] as String
            tvShareAddress.text = address
            val bitmap = QRCodeUtil.createQRCodeBitmap(address)
            ivQrCode.setImageBitmap(bitmap)
            v.findViewById<View>(R.id.tv_save_photo).setOnClickListener {
                onClickListener.onClick(bitmap)
            }
        }
    }

    fun showMainBoard(activity: AppCompatActivity?, title: String?, content: String) {
        CustomDialog.show(activity, R.layout.main_board) { dialog: CustomDialog, v: View ->
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            val tvTitle = v.findViewById<TextView>(R.id.tv_main_title)
            tvTitle.text = title
            val replace = content.replace("\\n", "\n")
            tvContent.text = CommonUtils.linkText(replace, tvContent)
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showPayAppDialog(activity: AppCompatActivity?, onClickListener: OnClickListener) {
        CustomDialog.show(activity, R.layout.dialog_pay_tip) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            val ybRecharge = SPUtil[Constants.YB_RECHARGE, ""] as String
            val replace = ybRecharge.replace("\\n", "\n")
            tvContent.text = replace
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
                onClickListener.onLeftClick(it)
                dialog.doDismiss()
            }

            v.findViewById<View>(R.id.tv_right).setOnClickListener {
                onClickListener.onRightClick(it)
                dialog.doDismiss()
            }
        }
    }

    fun showFloatButton(
        activity: AppCompatActivity?,
        onClickSingleListener: OnClickSingleListener
    ) {
        CustomDialog.show(activity, R.layout.dialog_float_button) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            val content = SPUtil[Constants.CONTRACT_CONTENT, ""] as String
            val replace = content.replace("\\n", "\n")
            tvContent.text = replace
            val tvSingle = v.findViewById<TextView>(R.id.tv_single)
            activity?.let {
                val contentText = when (SPUtil[Constants.CONTRACT_TYPE, ""] as String) {
                    Constants.CONTRACT_QQ -> {
                        Constants.CONTRACT_QQ_TEXT
                    }
                    Constants.CONTRACT_WE_CHAT -> {
                        Constants.CONTRACT_WE_CHAT_TEXT
                    }
                    else -> {
                        ""
                    }
                }
                tvSingle.text =
                    String.format(it.getString(R.string.string_float_content), contentText)
            }
            tvSingle.setOnClickListener {
                onClickSingleListener.onClick()
                dialog.doDismiss()
            }
        }
    }

    fun showShareFriend(
        activity: AppCompatActivity?,
        onClickSingleListener: OnClickSingleListener,
        type: Int = Constants.CONTRACT_TYPE_DEFAULT
    ) {
        CustomDialog.show(activity, R.layout.dialog_float_button) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            val link = SPUtil[Constants.SHARE_LINK, ""] as String
            setView(dialog)
            activity?.let {
                tvContent.text = String.format(it.getString(R.string.string_share_content), link)
            }

            val tvSingle = v.findViewById<TextView>(R.id.tv_single)
            activity?.let {
                when (type) {
                    Constants.CONTRACT_TYPE_DEFAULT -> {
                        val contractText = when (SPUtil[Constants.CONTRACT_TYPE, ""] as String) {
                            Constants.CONTRACT_QQ -> {
                                Constants.CONTRACT_QQ_TEXT
                            }
                            Constants.CONTRACT_WE_CHAT -> {
                                Constants.CONTRACT_WE_CHAT_TEXT
                            }
                            else -> {
                                ""
                            }
                        }
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            contractText
                        )
                    }
                    Constants.CONTRACT_TYPE_QQ -> {
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            Constants.CONTRACT_QQ_TEXT
                        )
                    }
                    Constants.CONTRACT_TYPE_WE_CHAT -> {
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            Constants.CONTRACT_WE_CHAT_TEXT
                        )
                    }
                    Constants.CONTRACT_TYPE_WEI_BO -> {
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            Constants.CONTRACT_WEI_BO_TEXT
                        )
                    }
                    Constants.CONTRACT_TYPE_TIE_BA -> {
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            Constants.CONTRACT_TIE_BA_TEXT
                        )
                    }
                    Constants.CONTRACT_TYPE_ZHI_HU -> {
                        tvSingle.text = String.format(
                            it.getString(R.string.string_friend_content),
                            Constants.CONTRACT_ZHI_HU_TEXT
                        )
                    }
                }

            }
            tvSingle.setOnClickListener {
                onClickSingleListener.onClick()
                dialog.doDismiss()
            }
        }
    }

    fun showPayWebDialog(activity: AppCompatActivity?, onClickListener: OnClickListener) {
        CustomDialog.show(activity, R.layout.dialog_pay_tip_web) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            val ybRecharge = SPUtil[Constants.YB_RECHARGE, ""] as String
            val replace = ybRecharge.replace("\\n", "\n")
            tvContent.text = replace
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
                onClickListener.onLeftClick(it)
                dialog.doDismiss()
            }

            v.findViewById<View>(R.id.tv_right).setOnClickListener {
                onClickListener.onRightClick(it)
                dialog.doDismiss()
            }
        }
    }

    fun showLoginAgreement(activity: AppCompatActivity?, title: String, content: String) {
        CustomDialog.show(activity, R.layout.dialog_login_agreement) { dialog, v ->
//            setView(dialog)
            v.findViewById<TextView>(R.id.tv_title).text = title
            v.findViewById<TextView>(R.id.tv_content).text = content
            v.findViewById<TextView>(R.id.tv_close).setOnClickListener { dialog.doDismiss() }
        }

    }

    fun showLogin(activity: AppCompatActivity?) {
        CustomDialog.show(activity, R.layout.dialog_login) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvLogin = v.findViewById<TextView>(R.id.tv_login)
            val tvAgreement = v.findViewById<TextView>(R.id.tv_agreement)
            val llLogin = v.findViewById<LinearLayout>(R.id.ll_login)
            val tvClose = v.findViewById<TextView>(R.id.tv_close)
            val cbAgree = v.findViewById<CheckBox>(R.id.cb_agree)
            val tvClosePrivate = v.findViewById<TextView>(R.id.tv_close_private)
            val rlUserAgreement = v.findViewById<RelativeLayout>(R.id.rl_user_agreement)
            val rlUserPrivate = v.findViewById<RelativeLayout>(R.id.rl_user_private)
            val style =
                SpannableStringBuilder(activity?.getString(R.string.string_user_agreement_title_new))
            val oneSpan = object : ClickableSpan() {
                override fun onClick(widget: View) {
                    activity?.let {
                        tvAgreement.highlightColor = it.resources.getColor(R.color.transparent)
                    }

                    llLogin.visibility = View.GONE
                    rlUserAgreement.visibility = View.VISIBLE
                }
            }

            val twoSpan = object : ClickableSpan() {
                override fun onClick(widget: View) {
                    activity?.let {
                        tvAgreement.highlightColor = it.resources.getColor(R.color.transparent)
                    }
                    llLogin.visibility = View.GONE
                    rlUserPrivate.visibility = View.VISIBLE
                }
            }

            activity?.let {
                style.setSpan(oneSpan, 12, 16, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                style.setSpan(twoSpan, 19, 23, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                style.setSpan(
                    ForegroundColorSpan(it.getColor(R.color.main_select)),
                    12,
                    16,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                style.setSpan(
                    ForegroundColorSpan(it.getColor(R.color.main_select)),
                    19,
                    23,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )

            }

            tvClose.setOnClickListener {
                llLogin.visibility = View.VISIBLE
                rlUserAgreement.visibility = View.GONE
            }
            tvClosePrivate.setOnClickListener {
                llLogin.visibility = View.VISIBLE
                rlUserPrivate.visibility = View.GONE
            }
            tvAgreement.movementMethod = LinkMovementMethod.getInstance();
            tvAgreement.text = style //将其添加到tv中
            tvLogin.setOnClickListener {
                if (cbAgree.isChecked) {
                    activity?.startActivity(Intent(activity, LoginActivity::class.java))
                    dialog.doDismiss()
                } else {
                    ToastUtil.s("请阅读并同意《用户协议》和《隐私协议》")
                }
            }
        }
    }

    fun showPirvate(activity: AppCompatActivity?, onClickListener: OnClickListener) {
        CustomDialog.show(activity, R.layout.dialog_first) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvAgreement = v.findViewById<TextView>(R.id.tv_agreement)
            val llLogin = v.findViewById<LinearLayout>(R.id.ll_login)
            val tvClose = v.findViewById<TextView>(R.id.tv_close)
            val tvClosePrivate = v.findViewById<TextView>(R.id.tv_close_private)
            val rlUserAgreement = v.findViewById<RelativeLayout>(R.id.rl_user_agreement)
            val rlUserPrivate = v.findViewById<RelativeLayout>(R.id.rl_user_private)
            val tvConfirm = v.findViewById<TextView>(R.id.tv_confirm)
            val tvCancel = v.findViewById<TextView>(R.id.tv_cancel)
            val style = SpannableStringBuilder(activity?.getString(R.string.string_first_login))

            val oneSpan = object : ClickableSpan() {
                override fun onClick(widget: View) {
                    activity?.let {
                        tvAgreement.highlightColor = it.resources.getColor(R.color.transparent)
                    }

                    llLogin.visibility = View.GONE
                    rlUserAgreement.visibility = View.VISIBLE
                }
            }

            val twoSpan = object : ClickableSpan() {
                override fun onClick(widget: View) {
                    activity?.let {
                        tvAgreement.highlightColor = it.resources.getColor(R.color.transparent)
                    }
                    llLogin.visibility = View.GONE
                    rlUserPrivate.visibility = View.VISIBLE
                }
            }

            activity?.let {
                style.setSpan(oneSpan, 86, 92, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                style.setSpan(twoSpan, 93, 97, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                style.setSpan(
                    ForegroundColorSpan(it.getColor(R.color.main_select)),
                    86,
                    92,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                style.setSpan(
                    ForegroundColorSpan(it.getColor(R.color.main_select)),
                    93,
                    97,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )

            }
            tvConfirm.setOnClickListener {
                onClickListener.onRightClick(it)
                dialog.doDismiss()
            }

            tvCancel.setOnClickListener {
                onClickListener.onLeftClick(it)
                dialog.doDismiss()
            }

            tvClose.setOnClickListener {
                llLogin.visibility = View.VISIBLE
                rlUserAgreement.visibility = View.GONE
            }
            tvClosePrivate.setOnClickListener {
                llLogin.visibility = View.VISIBLE
                rlUserPrivate.visibility = View.GONE
            }
            tvAgreement.movementMethod = LinkMovementMethod.getInstance();
            tvAgreement.text = style //将其添加到tv中


        }.cancelable = false
    }

    fun showSign(activity: AppCompatActivity?) {
        val arrayListOf = arrayListOf<String>()
        CustomDialog.show(activity, R.layout.dialog_sign) { dialog: CustomDialog, v: View ->
//            dialog.cancelable = false
            v.findViewById<ImageView>(R.id.iv_close).setOnClickListener { dialog.doDismiss() }
            v.findViewById<ImageView>(R.id.iv_share).setOnClickListener {
                CommonUtils.copy(SPUtil[Constants.SHARE_LINK, ""] as String)
                ToastUtil.s("复制成功")
                dialog.doDismiss()
            }
            val userBean = SPUtil.getSerializableObject<UserBean>(Constants.USER_BEAN)
            val tvDescribe = v.findViewById<TextView>(R.id.tv_main_des)
            val signRecycler = v.findViewById<RecyclerView>(R.id.recycler_sign)
            signRecycler.layoutManager =
                LinearLayoutManager(activity, RecyclerView.HORIZONTAL, false)
            activity?.let {
                val string =
                    String.format(it.getString(R.string.string_sign_success), userBean?.signInTotal)
                val style = SpannableStringBuilder(string)
                style.setSpan(
                    ForegroundColorSpan(it.resources.getColor(R.color.sign_text_new)),
                    3,
                    4,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                tvDescribe.text = style
                v.findViewById<TextView>(R.id.tv_sign_days).text = String.format(
                    it.getString(R.string.string_sign_success_tes),
                    userBean?.signInTotal
                )
                RecyclerViewUtil.addGridItemDecoration(
                    it,
                    signRecycler,
                    R.color.transparent,
                    Constants.item_divider
                )
            }

            val signInDate = userBean?.signInDate
            //从未签到过
            if (signInDate == null || signInDate.size == 0) {
                for (index in 0..6) {
                    arrayListOf.add(CommonUtils.getAppointDate(index))
                }
            }
            //签到过几天
            if (signInDate != null && signInDate.size > 0) {
                val differDate = CommonUtils.getCurrentDifferDay(signInDate[0])
                for (index in differDate..differDate + 6) {
                    arrayListOf.add(CommonUtils.getAppointDate(index))
                }
            }
            val signAdapter = NewSignAdapter(R.layout.item_sign_new, arrayListOf)
            signRecycler.adapter = signAdapter
        }.align = BaseDialog.ALIGN.BOTTOM
    }

    fun showUpDateApp(
        activity: AppCompatActivity?,
        content: String,
        isForce: Boolean,
        version: String,
        onUpdateClickListener: OnUpdateClickListener
    ) {
        CustomDialog.show(activity, R.layout.main_update) { dialog: CustomDialog, v: View ->
            dialog.cancelable = false
            v.findViewById<TextView>(R.id.tv_title).text = version
            v.findViewById<TextView>(R.id.tv_content).text = content.replace("\\n", "\n")
            val ivLeft = v.findViewById<ImageView>(R.id.iv_left)
            ivLeft.setOnClickListener { onUpdateClickListener.onLeftClick(dialog) }
            v.findViewById<ImageView>(R.id.iv_right).apply {
                setOnClickListener {
                    ivLeft.visibility = View.GONE
                    visibility = View.GONE
                    dialog.dialog.get()?.dialog?.setCanceledOnTouchOutside(false)
                    v.findViewById<LinearLayout>(R.id.ll_progress_bar).visibility = View.VISIBLE
                    onUpdateClickListener.onRightClick(
                        v.findViewById<TextView>(R.id.tv_progress),
                        v.findViewById<ProgressBar>(R.id.progress),
                        dialog
                    )
                }
            }
        }
    }

    fun showShareContent(activity: AppCompatActivity, link: String?) {
        CustomDialog.show(activity, R.layout.main_share) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val tvContent = v.findViewById<TextView>(R.id.tv_content)
            tvContent.text = String.format(activity.getString(R.string.string_share_content), link)
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showMineContactCustom(activity: AppCompatActivity?) {
        CustomDialog.show(
            activity,
            R.layout.contact_mine_customer
        ) { dialog: CustomDialog, v: View ->
            setView(dialog)
            val textView = v.findViewById<TextView>(R.id.tv_content)
            val content = SPUtil[Constants.CONTRACT_CONTENT, ""] as String
            val replace = content.replace("\\n", "\n")
            textView.text = replace
            v.findViewById<View>(R.id.ll_close).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showPayTips(activity: AppCompatActivity?, onClickSingleListener: OnClickSingleListener) {
        CustomDialog.show(activity, R.layout.pay_tips) { dialog: CustomDialog, v: View ->
            setView(dialog)
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
                onClickSingleListener.onClick()
//                BaseDialog.unload()
                dialog.doDismiss()
            }

        }
    }

    fun showContact(activity: AppCompatActivity?, onClickSingleListener: OnClickSingleListener) {
        CustomDialog.show(activity, R.layout.contact_custom) { dialog: CustomDialog, v: View ->
            setView(dialog)
            v.findViewById<View>(R.id.tv_left).setOnClickListener { v1: View? ->
                onClickSingleListener.onClick()
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    fun showDestroyUser(
        activity: AppCompatActivity?,
        onclick: () -> Unit
    ) {
        CustomDialog.show(activity, R.layout.dialog_destroy_user) { dialog: CustomDialog, v: View ->
            setView(dialog)
            v.findViewById<View>(R.id.tv_left).setOnClickListener { v1: View? ->
                onclick()
                dialog.doDismiss()
            }
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
                dialog.doDismiss()
            }
        }
    }

    fun showMatchLive(
        activity: AppCompatActivity?,
        list: List<MatchLiveBean?>?,
        onClickTextListener: OnClickTextListener
    ) {
        CustomDialog.show(activity, R.layout.dialog_match_live) { dialog: CustomDialog, v: View ->
            val recyclerView = v.findViewById<RecyclerView>(R.id.mRecyclerView)
            recyclerView.layoutManager = GridLayoutManager(activity, 2)
            val matchLiveAdapter = MatchLiveAdapter(R.layout.dialog_item_match_live)
            recyclerView.adapter = matchLiveAdapter
            matchLiveAdapter.setNewData(list)
//            RecyclerViewUtil.addGridItemDecoration(activity!!,recyclerView,R.color.view_color,1)
            matchLiveAdapter.setOnItemClickListener { adapter, view, position ->
                val item = adapter.getItem(position) as MatchLiveBean
                onClickTextListener.onClick(item.jumpLiveUrl)
                dialog.doDismiss()
            }
        }.align = BaseDialog.ALIGN.BOTTOM
    }

    fun showReContact(activity: AppCompatActivity?, onClickSingleListener: OnClickSingleListener) {
        CustomDialog.show(activity, R.layout.dialog_recontact) { dialog: CustomDialog, v: View ->
            setView(dialog)
            v.findViewById<View>(R.id.tv_left).setOnClickListener {
//                BaseDialog.unload()
                dialog.doDismiss()
            }
            v.findViewById<View>(R.id.tv_right).setOnClickListener {
                onClickSingleListener.onClick()
//                BaseDialog.unload()
                dialog.doDismiss()
            }
        }
    }

    private fun setView(dialog: CustomDialog) {
        val dialogWindow = dialog.dialog.get()?.dialog?.window
        dialogWindow?.setBackgroundDrawableResource(android.R.color.transparent)
        dialogWindow?.setGravity(Gravity.CENTER)
        val lp = dialogWindow?.attributes
        lp?.width = WindowManager.LayoutParams.MATCH_PARENT / 5 * 2
        lp?.height = WindowManager.LayoutParams.WRAP_CONTENT
        lp?.y = 0
        dialogWindow?.attributes = lp
    }

    private fun setViewBottom(dialog: CustomDialog) {
        val dialogWindow = dialog.dialog.get()?.dialog?.window
        dialogWindow?.setBackgroundDrawableResource(android.R.color.white)
        dialogWindow?.setGravity(Gravity.BOTTOM)
        val lp = dialogWindow?.attributes
        lp?.width = WindowManager.LayoutParams.MATCH_PARENT
        lp?.height = WindowManager.LayoutParams.WRAP_CONTENT
        lp?.y = 0
        dialogWindow?.attributes = lp
    }

    interface OnClickListener {
        fun onRightClick(view: View?)
        fun onLeftClick(view: View?)
    }

    interface OnBottomMenuListener {
        fun onclick(index: Int, text: String)
    }

    interface OnUpdateClickListener {
        fun onRightClick(view: TextView?, progressBar: ProgressBar?, dialog: CustomDialog?)
        fun onLeftClick(dialog: CustomDialog?)
    }

    interface OnClickSingleListener {
        fun onClick()
    }

    interface OnClickTextListener {
        fun onClick(text: String)
    }


    interface OnClickSingleViewListener {
        fun onClick(view: View?)
    }

    interface OnClickSaveBitmapListener {
        fun onClick(bitmap: Bitmap?)
    }
}
