package com.hupu.tv.player.app.utils


import android.util.Base64
import java.nio.charset.Charset
import java.security.Key
import javax.crypto.Cipher
import javax.crypto.SecretKeyFactory
import javax.crypto.spec.DESedeKeySpec
import javax.crypto.spec.IvParameterSpec


/**
 * @author by Dell
 * @date on 2020/7/11
 * @describe
 */

/**
 * Android 3DES加密工具类
 */

object EncodeUtils {
    private const val KEYSIZE = 1028 // 密钥位数
    const val RSA = "RSA" // 非对称加密密钥算法
    const val ECB_PADDING = "RSA/ECB/PKCS1Padding" //加密填充方式
    private const val RESERVE_BYTES = 11
    private const val DECRYPT_BLOCK = KEYSIZE / 8
    private const val ENCRYPT_BLOCK = DECRYPT_BLOCK - RESERVE_BYTES

        private const val PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDmfSpfrvtULUPrPX5ICkZ6Qb7ZWMB/Ptyj5TcY1X5bf8O/RH9kmFA6/QScUHfFkPa4XNIpczl3uwAgTcuhqt4gjvwTehowH1GJnVrR5VMkiRmOVa0p4AH+pqftkAck1y+FUYBM1UtAS4HuM+P9sVulNB7bOhPy8HEsUDusSYfaJwIDAQAB"
//    private const val PUBLIC_KEY = "swy35I6TzQuoBfZ13/oHQWgRCQ4uBE+UT7/JAvSXbmqns6dXIawxzXy0eqA4EzYVohROr0wHMo9Qs7hSPVKpgI1niRHWKywGCgp+7DZ36Y2/WiQMRCVnm53/SzSYAx4xkFDIVyM2eVQEWXubC6dthh0p+CVkuZcqpYdD/ms6+I4="

    @Throws(java.lang.Exception::class)
    fun encode(plainText: String): String? {
        var deskey: Key? = null
        val spec = DESedeKeySpec(secretKey.toByteArray())
        val keyfactory = SecretKeyFactory.getInstance("desede")
        deskey = keyfactory.generateSecret(spec)

        val cipher = Cipher.getInstance("desede/CBC/PKCS5Padding")
        val ips = IvParameterSpec(iv.toByteArray())
        cipher.init(Cipher.ENCRYPT_MODE, deskey, ips)
        val encryptData = cipher.doFinal(plainText.toByteArray(Charset.defaultCharset()))
        return Base64.encodeToString(encryptData, Base64.DEFAULT)
    }



//    @Throws(java.lang.Exception::class)
//    fun rsadecrypt(): String? {
//        return ConfigTools.decrypt("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDmfSpfrvtULUPrPX5ICkZ6Qb7ZWMB/Ptyj5TcY1X5bf8O/RH9kmFA6/QScUHfFkPa4XNIpczl3uwAgTcuhqt4gjvwTehowH1GJnVrR5VMkiRmOVa0p4AH+pqftkAck1y+FUYBM1UtAS4HuM+P9sVulNB7bOhPy8HEsUDusSYfaJwIDAQAB",
//                "swy35I6TzQuoBfZ13/oHQWgRCQ4uBE+UT7/JAvSXbmqns6dXIawxzXy0eqA4EzYVohROr0wHMo9Qs7hSPVKpgI1niRHWKywGCgp+7DZ36Y2/WiQMRCVnm53/SzSYAx4xkFDIVyM2eVQEWXubC6dthh0p+CVkuZcqpYdD/ms6+I4=")
//    }


    /**
     * 3DES解密
     *
     * @param encryptText
     * 加密文本
     * @return
     * @throws Exception
     */


    // 密钥 长度不得小于24
    private const val secretKey = "123456789012345678901234"

    // 向量 可有可无 终端后台也要约定
    private const val iv = "01234567"

    // 加解密统一使用的编码方式
    private const val encoding = "utf-8"

    @Throws(Exception::class)
    fun decryptByDES(encryptText: String?, secretKey: String): String {

        val spec = DESedeKeySpec(secretKey.toByteArray())
        val keyfactory: SecretKeyFactory = SecretKeyFactory.getInstance("desede")
        val deskey = keyfactory.generateSecret(spec)
        val cipher: Cipher = Cipher.getInstance("desede/CBC/PKCS5Padding")
        val ips = IvParameterSpec(iv.toByteArray())
        cipher.init(Cipher.DECRYPT_MODE, deskey, ips)
        val decryptData: ByteArray = cipher.doFinal(Base64.decode(encryptText, Base64.DEFAULT))
        return String(decryptData, Charset.defaultCharset())
    }
}