package com.hupu.tv.player.app.utils;

import android.graphics.Bitmap;
import android.os.Looper;
import android.util.Base64;


import com.softgarden.baselibrary.utils.ToastUtil;
import com.hupu.tv.player.app.app.App;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;


/**
 * @author by Dell
 * @date on 2020/7/11
 * @describe
 */
public class EncodeUtils2 {
    // 向量 可有可无 终端后台也要约定
    private final static String iv = "01234567";
    // 加解密统一使用的编码方式
    private final static String encoding = "utf-8";
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDmfSpfrvtULUPrPX5ICkZ6Qb7ZWMB/Ptyj5TcY1X5bf8O/RH9kmFA6/QScUHfFkPa4XNIpczl3uwAgTcuhqt4gjvwTehowH1GJnVrR5VMkiRmOVa0p4AH+pqftkAck1y+FUYBM1UtAS4HuM+P9sVulNB7bOhPy8HEsUDusSYfaJwIDAQAB";
    private final static String secretKey = "123456789012345678901234";

    public String rsadecrypt() {
        String decrypt = null;
        try {
//            decrypt = ConfigTools.decrypt("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDmfSpfrvtULUPrPX5ICkZ6Qb7ZWMB/Ptyj5TcY1X5bf8O/RH9kmFA6/QScUHfFkPa4XNIpczl3uwAgTcuhqt4gjvwTehowH1GJnVrR5VMkiRmOVa0p4AH+pqftkAck1y+FUYBM1UtAS4HuM+P9sVulNB7bOhPy8HEsUDusSYfaJwIDAQAB",
//                    "swy35I6TzQuoBfZ13/oHQWgRCQ4uBE+UT7/JAvSXbmqns6dXIawxzXy0eqA4EzYVohROr0wHMo9Qs7hSPVKpgI1niRHWKywGCgp+7DZ36Y2/WiQMRCVnm53/SzSYAx4xkFDIVyM2eVQEWXubC6dthh0p+CVkuZcqpYdD/ms6+I4=");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return decrypt;
    }

    public String decode(String encryptText) throws Exception {
        Key deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(secretKey.getBytes());
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(iv.getBytes());
        cipher.init(Cipher.DECRYPT_MODE, deskey, ips);

        byte[] decryptData = cipher.doFinal(Base64.decode(encryptText, Base64.DEFAULT));

        return new String(decryptData, encoding);
    }

    /**
     * Bitmap 通过Base64 转换为字符串
     *
     * @param bitmap
     * @return
     */
    public String getBitmapStrBase64(Bitmap bitmap) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, bos);
        byte[] bytes = bos.toByteArray();
        String string = Base64.encodeToString(bytes, Base64.DEFAULT);
        return string;
    }

    /**
     * 图片异或解密
     *
     * @param inputStream
     * @return
     */
    public ByteBuffer decryptUrl(InputStream inputStream) {
        byte[] buf = new byte[2048];
        int len;
        ByteArrayOutputStream fos = null;
        try {
            fos = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) != -1) {
                for (int i = 0; i < len; i++) {
                    buf[i] = (byte) (buf[i] ^ 1);
                }
                fos.write(buf, 0, len);
                // 下载中
            }
            fos.flush();
            return ByteBuffer.wrap(fos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                fos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ByteBuffer.wrap(fos.toByteArray());
    }


    public void getFile(String url, FileResultListener listener) {
        new Thread(() -> {
            Request request = new Request.Builder().url("http://agasound.cn/play/long/20200924251/20200924251.jpg.en").build();
            OkHttpClient okHttpClient = new OkHttpClient();
            okHttpClient.newCall(request).enqueue(new Callback() {
                @Override
                public void onFailure(Call call, IOException e) {
                    // 下载失败

                }

                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    InputStream is = null;
                    byte[] buf = new byte[2048];
                    int len = 0;
                    FileOutputStream fos = null;
                    // 储存下载文件的目录
                    String savePath = App.Companion.getInstance().getExternalCacheDir().getAbsolutePath() + File.separator;
                    try {
                        is = response.body().byteStream();
                        File file = new File(savePath, "51.jpg.en");
                        fos = new FileOutputStream(file);
                        while ((len = is.read(buf)) != -1) {
                            for (int i = 0; i < len; i++) {
                                buf[i] = (byte) (buf[i] ^ 1);
                            }
                            fos.write(buf, 0, len);
                            // 下载中
                        }
                        fos.flush();
                        listener.onFile(file);
                    } catch (Exception e) {
                        Looper.prepare();
                        ToastUtil.Companion.s("e:" + e);
                        Looper.loop();
                        e.printStackTrace();
                    } finally {
                        try {
                            if (is != null)
                                is.close();
                        } catch (IOException e) {
                        }
                        try {
                            if (fos != null)
                                fos.close();
                        } catch (IOException e) {
                        }
                    }
                }
            });
        }).start();


    }


    public void getPictureFile(String url, ByteResultListener listener) {
        new Thread(() -> {
            InputStream inStream = null;
            ByteArrayOutputStream outStream = null;
            Request request = new Request.Builder().url("http://agasound.cn/play/long/20200924251/20200924251.jpg.en").build();
            OkHttpClient okHttpClient = new OkHttpClient();
            //获取响应体
            okHttpClient.newCall(request).enqueue(new Callback() {
                @Override
                public void onFailure(Call call, IOException e) {
                    // 下载失败

                }

                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    InputStream is = null;
                    byte[] buf = new byte[1024];
                    int len = 0;
                    ByteArrayOutputStream fos = null;
                    // 储存下载文件的目录
                    try {
                        is = response.body().byteStream();
                        fos = new ByteArrayOutputStream();
                        while ((len = is.read(buf)) != -1) {
                            for (int i = 0; i < len; i++) {
                                buf[i] = (byte) (buf[i] ^ 1);
                            }
                            fos.write(buf, 0, len);
                        }
                        fos.flush();
                        listener.onByte(fos.toByteArray());
                    } catch (Exception e) {
                        Looper.prepare();
                        ToastUtil.Companion.s("e:" + e);
                        Looper.loop();
                        e.printStackTrace();
                    } finally {
                        try {
                            if (is != null)
                                is.close();
                        } catch (IOException e) {
                        }
                        try {
                            if (fos != null)
                                fos.close();
                        } catch (IOException e) {
                        }
                    }
                }
            });
            //获取流
            listener.onByte(null);
        }).start();


    }

    /**
     * 字符串 转换Bitmap
     *
     * @param str
     * @return
     */
    public byte[] stringToBitmap(String str) {
        byte[] input = null;
        String[] split = str.split(",");
        input = Base64.decode(split[1], Base64.DEFAULT);
//        Bitmap bitmap = BitmapFactory.decodeByteArray(input, 0, input.length);
        return input;
    }

    //从assets 文件夹中获取文件并读取数据
    public String getFromAssets(String fileName) {
        try {
            InputStreamReader inputReader = new InputStreamReader(App.Companion.getInstance().getResources().getAssets().open(fileName));
            BufferedReader bufReader = new BufferedReader(inputReader);
            String line = "";
            String Result = "";
            while ((line = bufReader.readLine()) != null)
                Result += line;
            return Result;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public interface ByteResultListener {
        void onByte(byte[] bytes);
    }

    public interface FileResultListener {
        void onFile(File file);
    }
}

