package com.hupu.tv.player.app.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;

import android.view.View;
import android.widget.ImageView;

import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import androidx.fragment.app.Fragment;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.gif.GifOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.widget.GlideRoundImage;

/**
 * 网络图片的工具类
 * <p>
 * (1)ImageView设置图片（错误图片）
 * （2）ImageView设置图片---BitMap(不设置默认图)
 * （3）设置RelativeLayout
 * （4）设置LinearLayout
 * （5）设置FrameLayout
 * （6）高斯模糊------ RelativeLayout
 * （7）高斯模糊------ LinearLayout
 * （8）圆角显示图片  ImageView
 * 使用工具类
 * （9）多种样式（模糊+圆角）
 *
 * @author huangshuyuan
 */
public class GlideUtils {


    /**
     * splash页面，不需要占位图
     */

    public static void loadImageSplash(Context context, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
//                .placeholder(placeHolder) //占位图
//                .error(placeHolder)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).apply(options).into(imageView);
    }


    /**
     * 默认加载
     */
    public static void loadImage(Fragment fragment, int resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(fragment).load(resId).apply(options).into(imageView);
    }


    public static void loadImage(Activity activity, int resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(activity).load(resId).apply(options).into(imageView);
    }

    public static void loadImage(View view, String resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(view).load(resId).apply(options).into(imageView);
    }

    public static void loadImage(View view, Object resId, ImageView imageView, int placeholder) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(placeholder) //占位图
                .error(placeholder)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(view).load(resId).apply(options).into(imageView);
    }

    public static void loadImage(Context context, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    public static void loadImageGift(Context context, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
//                .centerCrop()
                .centerInside()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(R.mipmap.bg_live_gift_place_holder).error(R.mipmap.bg_live_gift_place_holder).apply(options).into(imageView);
    }

    public static void loadImage(Fragment context, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }


    public static void loadImage(Context context, String url, ImageView imageView, int placeHolder) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadImage(Fragment context, String url, ImageView imageView, int placeHolder) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadImageNoCenter(Context context, String url, ImageView imageView, int placeHolder) {
        RequestOptions options = new RequestOptions()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadImageNoCenter(Fragment context, String url, ImageView imageView, int placeHolder) {
        RequestOptions options = new RequestOptions()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadImageNoCenter(Fragment context, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    /**
     * gif 图
     */
    public static void loadImageGif(Activity activity, String url, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(activity).asGif().load(url).apply(options).into(imageView);
    }

    /**
     * gif 图
     */
    public static void loadImageGif(Activity activity, int resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(activity).asGif().load(resId).apply(options).into(imageView);
    }

    /**
     * gif 图
     */
    public static void loadImageGif(Fragment context, int resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).asGif().load(resId).apply(options).into(imageView);
    }

    /**
     * gif 图
     */
    public static void loadImageGif(View context, int resId, ImageView imageView) {
        RequestOptions options = new RequestOptions()
                .placeholder(0) //占位图
                .error(0)       //错误图
                // .priority(Priority.HIGH)
                .set(GifOptions.DECODE_FORMAT, DecodeFormat.PREFER_ARGB_8888)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).asGif().load(resId).apply(options).into(imageView);
    }

    public static void loadImageGif(Activity activity, String url, ImageView imageView, int placeHoler) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(placeHoler) //占位图
                .error(placeHoler)       //错误图
                // .priority(Priority.HIGH)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(activity).asGif().load(url).apply(options).into(imageView);
    }


    /**
     * 加载圆形图片 从中间裁剪
     */

    public static void loadCirclePic(final Fragment context, String url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.place_holder_team_logo_small)
                .error(R.mipmap.place_holder_team_logo_small)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(new BitmapImageViewTarget(imageView) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(context.getResources(), resource);
                        circularBitmapDrawable.setCircular(true);
                        imageView.setImageDrawable(circularBitmapDrawable);
                    }
                });

    }

    public static void loadAvatar(final Fragment context, String url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.icon_default_avatar)
                .error(R.mipmap.icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(new BitmapImageViewTarget(imageView) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(context.getResources(), resource);
                        circularBitmapDrawable.setCircular(true);
                        imageView.setImageDrawable(circularBitmapDrawable);
                    }
                });

    }


    public static void loadAvatar(final Fragment context, int url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.icon_default_avatar)
                .error(R.mipmap.icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(imageView);

    }

    public static void loadAvatar(final Activity context, String url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.icon_default_avatar)
                .error(R.mipmap.icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(new BitmapImageViewTarget(imageView) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(context.getResources(), resource);
                        circularBitmapDrawable.setCircular(true);
                        imageView.setImageDrawable(circularBitmapDrawable);
                    }
                });

    }

    public static void loadAvatar(final View context, String url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.icon_default_avatar)
                .error(R.mipmap.icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(new BitmapImageViewTarget(imageView) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(context.getResources(), resource);
                        circularBitmapDrawable.setCircular(true);
                        imageView.setImageDrawable(circularBitmapDrawable);
                    }
                });

    }


    public static void loadCirclePic(final Activity context, String url, final ImageView imageView) {
        Glide.with(context)
                .asBitmap()
                .centerCrop()
                .load(url)
                .placeholder(R.mipmap.icon_default_avatar) //头像用黑色的
                .error(R.mipmap.icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.ALL) //设置缓存
                .into(new BitmapImageViewTarget(imageView) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(context.getResources(), resource);
                        circularBitmapDrawable.setCircular(true);
                        imageView.setImageDrawable(circularBitmapDrawable);
                    }
                });

    }

    /**
     * centerCrop 的圆角图片
     */
    public static void loadRoundCircleImageCenterCrop(Fragment fragment, String url, ImageView imageView, int radius) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(fragment).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCrop(Context context, String url, ImageView imageView, int radius) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    /**
     * byte[] 解密数组
     */
    public static void loadRoundCircleImageCenterCrop(Fragment fragment, byte[] url, ImageView imageView, int radius) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(fragment).load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    /**
     * 圆角gif
     */
    public static void loadRoundCircleImageCenterCropGif(Fragment fragment, String url, ImageView imageView, int radius) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(fragment).asGif().load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCropGif(Activity activity, String url, ImageView imageView, int radius) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(activity).asGif().load(url).placeholder(0).error(0).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCropGif(Fragment context, String url, ImageView imageView, int radius, int placeHolder) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).asGif().load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCropGif(Activity context, String url, ImageView imageView, int radius, int placeHolder) {
        RequestOptions options = new RequestOptions()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).asGif().load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    /**
     * 自定义占位图
     */

    public static void loadRoundCircleImageCenterCrop(Fragment fragment, String url, ImageView imageView, int radius, int placeHolder) {
        RequestOptions options = new RequestOptions()
                .centerCrop()
                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(fragment).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCrop(Context context, String url, ImageView imageView, int radius, int placeHolder) {
        RequestOptions options = new RequestOptions()

                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }

    public static void loadRoundCircleImageCenterCrop(View context, String url, ImageView imageView, int radius, int placeHolder) {
        RequestOptions options = new RequestOptions()

                .priority(Priority.HIGH)
                .bitmapTransform(new GlideRoundImage(radius))
                .diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with(context).load(url).placeholder(placeHolder).error(placeHolder).apply(options).into(imageView);
    }


}
