package com.hupu.tv.player.app.utils

import android.app.Activity
import android.graphics.Rect
import android.os.Build
import android.view.View
import android.view.ViewTreeObserver.OnGlobalLayoutListener
import android.view.WindowManager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class KeyBoardUtil(private val activity: Activity, contentView: View) {
    private var decorView: View? = null
    private var contentView: View? = null

    /**
     * 监听layout变化
     */
    fun register() {
        activity.window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
        if (Build.VERSION.SDK_INT >= 19) {
            decorView?.viewTreeObserver?.addOnGlobalLayoutListener(onGlobalLayoutListener)
        }
    }

    /**
     * 取消监听
     */
    fun unregister() {
        activity.window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN)
        if (Build.VERSION.SDK_INT >= 19) {
            decorView?.viewTreeObserver?.removeOnGlobalLayoutListener(onGlobalLayoutListener)
        }
    }

    private val onGlobalLayoutListener = OnGlobalLayoutListener {
        val r = Rect()
        decorView?.getWindowVisibleDisplayFrame(r)
        val height = decorView?.context?.resources?.displayMetrics?.heightPixels
        val diff = height!! - r.bottom
        if (diff != 0) {
            if (contentView.paddingBottom != diff) {
                contentView.setPadding(0, 0, 0, diff)
            }
        } else {
            if (contentView.paddingBottom != 0) {
                contentView.setPadding(0, 0, 0, 0)
            }
        }
    }

    /**
     * 构造函数
     *
     * @param act         需要解决bug的activity
     * @param contentView 界面容器，activity中一般是R.id.content，也可能是Fragment的容器，根据个人需要传递
     */
    init {
        decorView = activity.window.decorView
        this.contentView = contentView
    }
}