package com.hupu.tv.player.app.utils

import android.content.Context
import com.bumptech.glide.GlideBuilder
import com.bumptech.glide.annotation.GlideModule
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper
import com.bumptech.glide.module.AppGlideModule
import com.softgarden.baselibrary.BaseApplication
import java.io.File

@GlideModule
class MyGlideModule : AppGlideModule() {
    override fun applyOptions(context: Context, builder: GlideBuilder) {
        builder.setDiskCache { //设置glide的缓存目录,与缓存文件夹的大小限制
            val cacheLocation = File(BaseApplication.instance?.externalCacheDir, "images")
            cacheLocation.mkdirs()
            DiskLruCacheWrapper.create(cacheLocation, 150 * 1024 * 1024.toLong())
        }
    }

    override fun isManifestParsingEnabled(): Boolean {
        return false
    }
}