package com.hupu.tv.player.app.utils

import android.content.pm.ApplicationInfo
import android.content.pm.PackageManager
import android.os.Bundle
import android.text.TextUtils
import com.hupu.tv.player.app.app.App


/**
 * @author by Dell
 * @date on 2022/3/19
 * @describe
 */
object ProductFlavors {
    //这个常量值必须在 androidManifest配置后引用 productFlavors的才能用
    const val UM_CHANNEL_ID = "UMENG_CHANNEL"
    const val API_CHANNEL = "API_CHANNEL"
    const val APP_NAME = "APP_NAME"
    const val APP_NAME_PY = "APP_NAME_PY"

    fun getString(data: String): String {
        return getMetaDataStr(data)
    }
    fun getInt(data: String): Int {
        return getMetaDataInt(data)
    }

    private fun getMetaDataStr(key: String?): String {
        return getAppInfoBundle()?.getString(key).orEmpty()


    }

    private  fun getMetaDataInt(key: String?): Int {
        return getAppInfoBundle()?.getInt(key) ?: 0

    }

    private fun getAppInfoBundle(): Bundle? {
        return getAppInfo()?.metaData
    }

    private fun getAppInfo(): ApplicationInfo? {
        val packageManager: PackageManager? = App.instance?.packageManager
        var applicationInfo: ApplicationInfo? = null
        if (packageManager != null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(
                    App.instance?.packageName.orEmpty(),
                    PackageManager.GET_META_DATA
                )
            } catch (e: PackageManager.NameNotFoundException) {
                e.printStackTrace()
            }
        }
        return applicationInfo
    }
}