package com.hupu.tv.player.app.utils

import com.google.gson.reflect.TypeToken
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.event.RefreshAvatarEvent
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.softgarden.baselibrary.utils.SPUtil
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2022/1/8
 * @describe
 */
object UserHelper {

    fun userLoginSuccessForPhone(userBean: LiveUserBean?, phone: String) {
        SPUtil.putSerializableObject(Constants.LIVE_USER_BEAN, userBean)
        SPUtil.put(Constants.USER_PHONE, phone)
        SPUtil.put(Constants.USER_LOGIN, true)
        EventBus.getDefault().post(RefreshUserEvent())
        EventBus.getDefault().post(RefreshAvatarEvent())
    }

    fun userLoginSaveToken(token: String?){
        SPUtil.put(Constants.TOKEN, token)
    }

    fun userLoginSuccess(userBean: LiveUserBean?) {
        SPUtil.putSerializableObject(Constants.LIVE_USER_BEAN, userBean)
        SPUtil.put(Constants.USER_LOGIN, true)
        EventBus.getDefault().post(RefreshUserEvent())
        EventBus.getDefault().post(RefreshAvatarEvent())
    }

    fun userExitLoginSuccess() {
        SPUtil.put(Constants.TOKEN, "")
        SPUtil.put(Constants.USER_LOGIN, false)
        EventBus.getDefault().post(RefreshUserEvent())
        CommonUtils.umengLoginOut()
        EventBus.getDefault().post(RefreshAvatarEvent())
    }

    fun getUserBean():LiveUserBean?{
        return SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
    }

    fun isLogin():Boolean{
        return SPUtil[Constants.USER_LOGIN, false] as Boolean
    }

}