package com.hupu.tv.player.app.utils

import com.hupu.tv.player.app.BuildConfig
import com.hupu.tv.player.app.app.Constants
import com.softgarden.baselibrary.utils.SPUtil

/**
 * @author by Dell
 * @date on 2022/4/29
 * @describe
 *
 */
object VersionControl {
    private const val OFFICIAL_1 = "qj_01"
    private const val OFFICIAL_2 = "qj_02"
    private const val OFFICIAL_3 = "qj_yuyan_01"
    private const val BAIDU = "qj_baidu"
    private const val VIVO = "qj_vivo_01"
    private const val HUAWEI = "qj_huawei_01"
    private const val OPPO = "qj_oppo_01"


    fun isShowLive(): Boolean {
        return SPUtil[Constants.SHOW_LIVE_CONFIG, false] as Boolean
    }

    fun saveConfig(showConfig: Boolean) {
        when (BuildConfig.FLAVOR) {
            BAIDU, VIVO, HUAWEI, OPPO -> SPUtil.put(Constants.SHOW_LIVE_CONFIG, showConfig)
            else -> SPUtil.put(Constants.SHOW_LIVE_CONFIG, true)
        }
    }

    fun showIndex(): Boolean {
        return isShowLive()
    }

    fun showRedList(): Boolean {
        return isShowLive()
    }
}