package com.hupu.tv.player.app.widget

import android.content.Context
import android.util.AttributeSet
import android.widget.ImageView
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer
import com.shuyu.gsyvideoplayer.video.base.GSYVideoView
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.widget.viewpager.viewpagerlayoutmanager.OnPlayerListener
import me.jessyan.autosize.utils.LogUtils


/**
 * @author by Dell
 * @date on 2020/6/25
 * @describe
 */
class CustomLayoutGSYVideoPlayer : StandardGSYVideoPlayer {
    private var onClickStartButton: OnClickStartButton? = null
    private var ivStartPlay: ImageView? = null
    private var onClickBackButton: OnClickBackButton? = null
    private var onPlayerListener: OnPlayerListener? = null
    //isClickPlayer是响应点击事件的逻辑
    var isCanPlay: Boolean = false
    var isClickPlayer: Boolean = true


    constructor(context: Context?, fullFlag: Boolean?) : super(context, fullFlag) {}
    constructor(context: Context?) : super(context) {}
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs) {}

    override fun getLayoutId(): Int {
        return R.layout.video_layout_custom_gsy
    }

    fun setOnPlayerListener(onPlayerListener: OnPlayerListener?) {
        this.onPlayerListener = onPlayerListener;
    }

    fun setOnClickStartButton(onClickStartButton: OnClickStartButton?) {
        this.onClickStartButton = onClickStartButton
    }

    fun setOnClickBackButton(onClickBackButton: OnClickBackButton) {
        this.onClickBackButton = onClickBackButton
    }

    override fun init(context: Context?) {
        super.init(context)

        ivStartPlay = findViewById(R.id.start)
        ivStartPlay?.let {
            it.setOnClickListener { _ ->
                when (mCurrentState) {
                    CURRENT_STATE_PLAYING -> {
                        onVideoPause()
                    }

                    CURRENT_STATE_PAUSE -> {
                        onResumePlay()
                    }
                }
            }
        }
        setStatus()
    }


    override fun touchSurfaceMoveFullLogic(absDeltaX: Float, absDeltaY: Float) {
        super.touchSurfaceMoveFullLogic(absDeltaX, absDeltaY)
        //不给触摸快进，如果需要，屏蔽下方代码即可
        mChangePosition = false

        //不给触摸音量，如果需要，屏蔽下方代码即可
        mChangeVolume = false

        //不给触摸亮度，如果需要，屏蔽下方代码即可
        mBrightness = false
    }

    override fun onSeekComplete() {
        super.onSeekComplete()
        if (currentPlayer.currentState == GSYVideoView.CURRENT_STATE_PAUSE) {
            currentPlayer.startPlayLogic()
        }
    }


    private fun onResumePlay() {
        clickStartIcon()
    }

    override fun onPrepared() {
        super.onPrepared()
        LogUtils.e(" PagerLayout onPrepared currentState:$mCurrentState")
        val currentPlayer = currentPlayer as CustomLayoutGSYVideoPlayer
        currentPlayer.ivStartPlay?.setImageResource(0)
        onClickStartButton?.onStart()
    }

//    //去掉双击触摸
//    override fun touchDoubleUp() {
////        super.touchDoubleUp()
//    }

    /**
     * 单击显示
     */
//    override fun onClickUiToggle() {
//        super.onClickUiToggle()
//        if (isClickPlayer){
//            onResumePlay()
//        }else{
//            onPlayerListener?.onClickScreen()
//        }
//
//    }


//
//    /**
//     * 在全屏处理的时候需要加上自己新增的View
//     * 新的点击逻辑需要自己实现，并且返回的是全屏播放器，需要全屏播放器去找新的Id，不然无法更换资源
//     */
//    override fun startWindowFullscreen(context: Context?, actionBar: Boolean, statusBar: Boolean): GSYBaseVideoPlayer {
//        val gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar)
//        customPlayer = gsyBaseVideoPlayer as CustomLayoutGSYVideoPlayer
//        customPlayer?.ivStartPlay = customPlayer?.findViewById(R.id.iv_start_play)
//        customPlayer?.progressBarBuffer = customPlayer?.findViewById(R.id.custom_progress_bar)
//        return gsyBaseVideoPlayer
//    }


    override fun updateStartImage() {
        super.updateStartImage()
//        custom_progress_bar.visibility = View.GONE
        when (mCurrentState) {
            GSYVideoView.CURRENT_STATE_PLAYING -> {
                setImageVIewRes(R.mipmap.icon_play_pause)
                if (startButton is ImageView) {
//                    (startButton as ImageView).setImageResource(R.mipmap.icon_video_pause)
                    (startButton as ImageView).setImageResource(0)
                }
            }
            GSYVideoView.CURRENT_STATE_PAUSE -> {
                setImageVIewRes(R.mipmap.icon_play_start)
                if (startButton is ImageView) {
                    (startButton as ImageView).setImageResource(R.mipmap.icon_video_play)
                }
            }
            GSYVideoView.CURRENT_STATE_NORMAL -> {
                if (startButton is ImageView) {
                    (startButton as ImageView).setImageResource(R.mipmap.icon_video_play)
                }
            }
        }
    }
//    //显示加载loading
//    override fun changeUiToPlayingBufferingShow() {
//        super.changeUiToPlayingBufferingShow()
//        setViewShowState(mLoadingProgressBar, View.INVISIBLE)
//        setViewShowState(progressBarBuffer, View.VISIBLE)
//    }
//    //隐藏加载loading
//    override fun changeUiToPauseShow() {
//        super.changeUiToPauseShow()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//
//    }
//    //隐藏加载loading
//    override fun changeUiToPlayingShow() {
//        super.changeUiToPlayingShow()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//    //隐藏加载loading
//    override fun changeUiToNormal() {
//        super.changeUiToNormal()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//    //隐藏加载loading
//    override fun changeUiToCompleteClear() {
//        super.changeUiToCompleteClear()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//    //隐藏加载loading
//    override fun changeUiToCompleteShow() {
//        super.changeUiToCompleteShow()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//    override fun  changeUiToPreparingShow(){
//        super.changeUiToPreparingShow()
//        setViewShowState(mLoadingProgressBar, View.INVISIBLE)
//        setViewShowState(progressBarBuffer, View.VISIBLE)
//    }
//    override fun  changeUiToError(){
//        super.changeUiToError()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//
//    override fun  changeUiToPrepareingClear(){
//        super.changeUiToPrepareingClear()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }
//    override fun  changeUiToPlayingBufferingClear(){
//        super.changeUiToPlayingBufferingClear()
//        setViewShowState(mLoadingProgressBar, View.INVISIBLE)
//        setViewShowState(progressBarBuffer, View.VISIBLE)
//    }
//    override fun  changeUiToClear(){
//        super.changeUiToClear()
//        setViewShowState(progressBarBuffer, View.INVISIBLE)
//    }

    private fun setImageVIewRes(resId: Int) {
        LogUtils.e("mCurrentState 104$mCurrentState======iconId$resId")
        val currentPlayer:CustomLayoutGSYVideoPlayer? = currentPlayer as CustomLayoutGSYVideoPlayer
        currentPlayer?.ivStartPlay?.setImageResource(resId)
    }

    private fun setStatus() {
        val currentPlayer = currentPlayer as CustomLayoutGSYVideoPlayer
        if (currentState == CURRENT_STATE_PLAYING) {
            currentPlayer.ivStartPlay?.setImageResource(R.mipmap.icon_play_pause)
            currentPlayer.ivStartPlay?.setImageResource(0)
        } else {
            currentPlayer.ivStartPlay?.setImageResource(R.mipmap.icon_play_start)
        }
    }

//    /**
//     * 克隆参数的时候需要转成自定义的Player
//     */
//    override fun cloneParams(from: GSYBaseVideoPlayer?, to: GSYBaseVideoPlayer?) {
//        super.cloneParams(from, to)
//        var customFrom: CustomLayoutGSYVideoPlayer = from as CustomLayoutGSYVideoPlayer
//        var customTo: CustomLayoutGSYVideoPlayer = to as CustomLayoutGSYVideoPlayer
//        customTo.ivStartPlay = customFrom.ivStartPlay
//        customTo.progressBarBuffer = customFrom.progressBarBuffer
//        customTo.mShowFullAnimation = customFrom.mShowFullAnimation
//    }

//    /**
//     * 退出window层播放全屏效果
//     */
//    override fun clearFullscreenLayout() {
//        mIfCurrentIsFullscreen = false
//        var delay = 0
//        if (mOrientationUtils != null) {
//            delay = mOrientationUtils.backToProtVideo()
//            mOrientationUtils.isEnable = false
//            if (mOrientationUtils != null) {
//                mOrientationUtils.releaseListener()
//                mOrientationUtils = null
//            }
//        }
//        if (!mShowFullAnimation) {
//            delay = 0
//        }
//        val vp = CommonUtil.scanForActivity(context).findViewById<ViewGroup>(Window.ID_ANDROID_CONTENT)
//        val oldF: View = vp.findViewById(fullId)
//        if (oldF != null) {
//            //此处fix bug#265，推出全屏的时候，虚拟按键问题
//            val gsyVideoPlayer: CustomLayoutGSYVideoPlayer = oldF as CustomLayoutGSYVideoPlayer
//            gsyVideoPlayer.mIfCurrentIsFullscreen = false
//        }
//        if (delay == 0) {
//            backToNormal()
//        } else {
//            postDelayed({ backToNormal() }, delay.toLong())
//        }
//    }

//    /**
//     * 关闭全屏的时候，把id返回
//     */
//    override fun resolveNormalVideoShow(oldF: View?, vp: ViewGroup?, gsyVideoPlayer: GSYVideoPlayer?) {
//        super.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer)
//        if (gsyVideoPlayer != null) {
//            customPlayer = gsyVideoPlayer as CustomLayoutGSYVideoPlayer?
//            ivStartPlay = findViewById(R.id.iv_start_play)
//            progressBarBuffer = findViewById(R.id.custom_progress_bar)
//        }
//    }

    interface OnClickStartButton {
        fun onStart()
    }

    interface OnClickBackButton {
        fun onBack()
    }


}