package com.hupu.tv.player.app.widget;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.hupu.tv.player.app.R;

/**
 * @author by Dell
 * @date on 2020/7/6
 * @describe
 */
public class CustomRefreshHeaderView extends LinearLayout implements RefreshHeader {
    private TextView tvRefresh;
    private LinearLayout llText;
    private LinearLayout llAnim;
    private ImageView ivLeft;
    private TextView tvText;
    private Context mContext;
    private AnimationDrawable animationDrawable;

    public CustomRefreshHeaderView(Context context) {
        this(context, null);
    }

    public CustomRefreshHeaderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomRefreshHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        View view = LayoutInflater.from(context).inflate(R.layout.custom_refresh_head, null);
        view.setLayoutParams(layoutParams);
        llText = view.findViewById(R.id.ll_text);
        llAnim = view.findViewById(R.id.ll_anim);
        ivLeft = view.findViewById(R.id.iv_left);
        tvText =view.findViewById(R.id.tv_text);
        addView(view);
        init(context);
    }

    private void init(Context context) {

    }

    public void setBackgroundColor(int color){
        if (llText!=null){
            llText.setBackgroundColor(color);
        }

    }

    public void setTextColor(int color){
        if (tvText !=null){
            tvText.setTextColor(color);
        }

    }


    @NonNull
    @Override
    public View getView() {
        return this;
    }

    @NonNull
    @Override
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Translate;
    }


    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        starAnim();
        //开始动画
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        //停止动画
        animationDrawable.stop();
        

        return 500;//延迟500毫秒之后再弹回
    }


    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        switch (newState) {
            case None:
            case PullDownToRefresh:
                llText.setVisibility(View.VISIBLE);
                llAnim.setVisibility(View.GONE);
//                mHeaderText.setText("下拉开始刷新");
//                mArrowView.setVisibility(VISIBLE);//显示下拉箭头
//                mProgressView.setVisibility(GONE);//隐藏动画
//                mArrowView.animate().rotation(0);//还原箭头方向
                break;
            case Refreshing:
                llText.setVisibility(View.GONE);
                llAnim.setVisibility(View.VISIBLE);
//                mHeaderText.setText("正在刷新");
//                mProgressView.setVisibility(VISIBLE);//显示加载动画
//                mArrowView.setVisibility(GONE);//隐藏箭头
                break;
            case ReleaseToRefresh:
//                mHeaderText.setText("释放立即刷新");
//                mArrowView.animate().rotation(180);//显示箭头改为朝上
                break;
        }
    }

    private void starAnim() {
        animationDrawable = (AnimationDrawable) ivLeft.getBackground();
        animationDrawable.start();
    }

    @Override
    public void setPrimaryColors(int... colors) {
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
    }

    @Override
    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
    }

    @Override
    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

}
