package com.hupu.tv.player.app.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;

import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.softgarden.baselibrary.utils.DisplayUtil;
import com.hupu.tv.player.app.R;

import java.lang.ref.WeakReference;

/**
 * @author by Dell
 * @date on 2020/7/6
 * @describe
 */
public class DoubleCircleView extends View {
    public static final int MESSAGE_ID = 0;
    //白色圆点
    private Paint mWhitePaint;
    //绿色圆点
    private Paint mRedPaint;
    //半径
    private int mRadius;
    //双方的偏移量
    private float mOffset;

    private Context mContext;
    private InnerHandler mHandler;


    public DoubleCircleView(Context context) {
        this(context, null);
    }


    public DoubleCircleView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);

    }

    public DoubleCircleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        init(context);
    }

    private void init(Context context) {
        initHandler();
        initParams(context);
    }
    private void initParams(Context context) {
        mWhitePaint = new Paint();
        mWhitePaint.setAntiAlias(true);
        mWhitePaint.setStyle(Paint.Style.FILL);
        mWhitePaint.setColor(ContextCompat.getColor(context, R.color.white));



        mRedPaint = new Paint();
        mRedPaint.setAntiAlias(true);
        mRedPaint.setStyle(Paint.Style.FILL);
        mRedPaint.setColor(ContextCompat.getColor(context, R.color.red));


        mOffset = DisplayUtil.INSTANCE.dip2px(context, 20);
        mRadius = DisplayUtil.INSTANCE.dip2px(context, 5);
    }

    private void initHandler() {
        mHandler = new InnerHandler(mContext) {

            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                postInvalidate();
            }
        };
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < 10; i++) {
            canvas.drawCircle(getWidth() / 2-(mOffset/(10-i)) , getHeight() / 2, mRadius, mWhitePaint);
            canvas.drawCircle(getWidth() / 2+(mOffset/(10-i)), getHeight() / 2, mRadius, mRedPaint);
        }
        mHandler.sendEmptyMessageDelayed(MESSAGE_ID, 200);
    }

    private static class InnerHandler extends Handler {
        private  WeakReference contextWeakReference;

        public InnerHandler(Context context) {
            contextWeakReference = new WeakReference(context);
        }

        @Override
        public void handleMessage(Message msg) {
            if (contextWeakReference.get() == null) {
                return;
            }
        }
    }

    //停止动画
    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        mHandler.removeMessages(MESSAGE_ID);
        mHandler = null;
    }

}
