package com.hupu.tv.player.app.widget


import android.view.View
import android.widget.TextView
import androidx.viewpager.widget.ViewPager
import com.softgarden.baselibrary.base.BaseFragment
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.BannerBean
import com.hupu.tv.player.app.ui.adapter.ImagesPagerAdapter
import com.zhy.http.okhttp.utils.L
import java.lang.ref.WeakReference
import java.util.*

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class ImageCarousel(private val mFragment: BaseFragment<*>, viewPager: ViewPager?, tvTitle: TextView?,
                    dots: List<View?>?, time: Int) {
    private var adBeanList = ArrayList<BannerBean>()
    private val time: Int
    private var previousPosition = 1 //前一个被选中的position
    private var onPageChangeListener: ViewPager.OnPageChangeListener? = null
    var adapter: ImagesPagerAdapter? = null
    private var runnable: Runnable? = null
    var weakReference: WeakReference<ViewPager?>? = null
    var weakReferenceT: WeakReference<TextView?>? = null
    var weakReferenceV: WeakReference<List<View?>?>? = null

    @Volatile
    private var isExit = true
    private var onItemClickListener: OnItemClickListener? = null
    fun setOnItemClickListener(onItemClickListener: OnItemClickListener?) {
        this.onItemClickListener = onItemClickListener
    }

    /**
     * 传入数据
     *
     * @return this 本身
     */
    fun init(arrayList: ArrayList<BannerBean>?): ImageCarousel {
        if (arrayList != null) {
            adBeanList = arrayList
        }
        //        L.e("image", "init");
        return this
    }

    /**
     * 重新加载，有待考验...
     */
    fun reload(arrayList: ArrayList<BannerBean>?) {
        init(arrayList)
        previousPosition = 0
        start()
    }

    /**
     * 设置设配器，并实现轮播功能
     */
    fun start() {
        L.e("start")
        if (adBeanList.size == 0) {
            return
        }
        if (adapter != null) {
            adapter = null
        }
        weakReference?.get()?.let {
            adapter = ImagesPagerAdapter(adBeanList, it, mFragment)
            it.adapter = adapter
        }
        onPageChangeListener = object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {}

            //当被选择
            override fun onPageSelected(position: Int) {
                val currentPosition: Int = when (position) {
                    adBeanList.size - 1 -> {
                        // 设置当前值为1
                        FIRST_PAGE
                    }
                    0 -> {
                        // 如果索引值为0了,就设置索引值为倒数第二个
                        adBeanList.size - 2
                    }
                    else -> {
                        position
                    }
                }

                // 把当前选中的点给切换了, 还有描述信息也切换
                weakReferenceT?.get()?.let {
                    it.text = adBeanList[currentPosition].adDes
                }

                //设置轮播点 可设置成传入的图
//                Log.d("dots", "position:"+position+"previousPosition=" + previousPosition + " currentPosition=" + currentPosition);
                weakReferenceV?.get()?.let {
                    it[previousPosition - 1]?.setBackgroundResource(R.drawable.shape_dot_normal)
                    it[currentPosition - 1]?.setBackgroundResource(R.drawable.shape_dot_focused)
                }

                // 把当前的索引赋值给前一个索引变量, 方便下一次再切换.
                previousPosition = currentPosition
            }

            override fun onPageScrollStateChanged(state: Int) {
                // SCROLL_STATE_IDLE ：空闲状态
                // SCROLL_STATE_DRAGGING ：滑动状态
                // SCROLL_STATE_SETTLING ：滑动后滑翔的状态
                if (state == ViewPager.SCROLL_STATE_DRAGGING) {
                } else if (state == ViewPager.SCROLL_STATE_IDLE) {
                }
            }
        }
        weakReference?.get()?.let { view ->
            onPageChangeListener?.let {
                view.addOnPageChangeListener(it)
            }

        }

        setFirstLocation()
        adapter?.setOnItemClickListener { position: Int ->
            onItemClickListener?.let {
                it.onClick(adBeanList[position].adUrl,adBeanList[position].adUrl)
            }
        }
    }

    /**
     * 设置刚打开app时显示的图片和文字
     */
    private fun setFirstLocation() {
//        L.e("thread", "setFirstLocation");
        weakReferenceT?.get()?.let {
            it.text = adBeanList[0].adDes
        }
        weakReferenceV?.get()?.let {
            it[0]?.setBackgroundResource(R.drawable.shape_dot_focused)
        }
        weakReference?.get()?.let {
            it.currentItem = 1
        }
    }

    fun stopAutoPlay() {
//        L.e("thread", "stopAutoPlay");
        isExit = true
    }

    /**
     * 请求继续
     */
    fun startAutoPlay() {
        stopAutoPlay()
        weakReference?.get()?.let {
            it.removeCallbacks(runnable)
        }
        isExit = false
        //        L.e("thread", "开始");
        if (runnable == null) {
            run()
        }
        weakReference?.get()?.let {
            it.postDelayed(runnable, time.toLong())
        }

    }

    /**
     * 自动播放线程，添加暂停和继续方法
     */
    private fun run() {
        runnable = Runnable {
            if (!isExit) {
//                    L.e("thread", "viewpager" + weakReference.get().toString());
                weakReference?.get()?.let {
                    it.currentItem = it.currentItem + 1
                    it.postDelayed(runnable, time.toLong())
                }

            }
        }
    }

    interface OnItemClickListener {
        fun onClick(url: String?,adType:String)
    }

    companion object {
        private const val FIRST_PAGE = 1
    }

    init {
        weakReference = WeakReference(viewPager)
        weakReferenceT = WeakReference(tvTitle)
        weakReferenceV = WeakReference(dots)
        this.time = time
        //        L.e("image", "构造方法");
    }
}