package com.hupu.tv.player.app.widget;
//
//import android.annotation.SuppressLint;
//import android.content.Context;
//import android.content.pm.ActivityInfo;
//import android.graphics.Rect;
//import android.media.AudioManager;
//import android.os.Build;
//import android.os.Handler;
//import android.os.Message;
//import android.util.AttributeSet;
//import android.view.Gravity;
//import android.view.KeyEvent;
//import android.view.LayoutInflater;
//import android.view.MotionEvent;
//import android.view.View;
//import android.widget.FrameLayout;
//import android.widget.ImageView;
//import android.widget.PopupWindow;
//import android.widget.ProgressBar;
//import android.widget.SeekBar;
//import android.widget.TextView;
//
//import com.pili.pldroid.player.IMediaController;
//import com.pili.pldroid.player.widget.PLVideoTextureView;
//import com.softgarden.baselibrary.utils.L;
//import com.video.player.hszb.R;
//import com.video.player.hszb.utils.CommonUtils;
//
///**
// * You can write a custom MediaController instead mWindow.geof this class
// * A MediaController widget must implement all the interface defined by com.pili.pldroid.player.IMediaController
// */
//public class MediaController extends FrameLayout implements IMediaController {
//
//    private static final String TAG = "PLMediaController";
//    private IMediaController.MediaPlayerControl mPlayer;
//    private Context mContext;
//    private PopupWindow mWindow;
//    private int mAnimStyle;
//    private View mAnchor;
//    private View mRoot;
//    private ProgressBar mProgress;
//    private TextView mEndTime, mCurrentTime;
//    private int requestedOrientation;
//    private View titleView;
//    private long mDuration;
//    private boolean mShowing;
//    private boolean mDragging;
//    private boolean mInstantSeeking = true;
//    private static int sDefaultTimeout = 3000;
//    private static final int SEEK_TO_POST_DELAY_MILLIS = 200;
//    private onFullScreenListener onFullScreenListener;
//    private static final int FADE_OUT = 1;
//    private static final int SHOW_PROGRESS = 2;
//    private boolean mFromXml = false;
//    private ImageView mPauseButton;
//    private PLVideoTextureView videoTextureView;
//    private AudioManager mAM;
//    private Runnable mLastSeekBarRunnable;
//    private boolean mDisableProgress = false;
//    private OnClickSpeedAdjustListener mOnClickSpeedAdjustListener;
//    private ImageView startPlay;
//    private boolean isShowStart;
//    private boolean isEnable;
//    private OnSeekBarListener onSeekBarListener;
//    private SeekBar seeker;
//    private boolean keepShow;
//
//    public void setOnSeekBarListener(OnSeekBarListener onSeekBarListener) {
//        this.onSeekBarListener = onSeekBarListener;
//    }
//
//    public interface OnSeekBarListener {
//        void onPosition(long position);
//    }
//
//    public interface OnClickSpeedAdjustListener {
//        void onClickNormal();
//
//        void onClickFaster();
//
//        void onClickSlower();
//    }
//
//    public void isShowStart(Boolean isShowStart) {
//        this.isShowStart = isShowStart;
//    }
//
//    public void isClickEnable(boolean isEnable) {
//        this.isEnable = isEnable;
//    }
//
//    public void setOnFullScreenListener(onFullScreenListener onFullScreenListener) {
//        this.onFullScreenListener = onFullScreenListener;
//    }
//
//
//    public MediaController(Context context, AttributeSet attrs) {
//        super(context, attrs);
//        mContext = context;
//        mRoot = this;
//        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT;
//        mFromXml = true;
//        initController();
//    }
//
//    public void setRequestedOrientation(int requestedOrientation) {
//        this.requestedOrientation = requestedOrientation;
//    }
//
//    public MediaController(Context context) {
//        super(context);
//    }
//
//    public MediaController(Context context, boolean useFastForward, boolean disableProgressBar, PLVideoTextureView videoTextureView) {
//        this(context);
//        this.videoTextureView = videoTextureView;
//        mDisableProgress = disableProgressBar;
//        mContext = context;
//        if (!mFromXml && initController())
//            initFloatingWindow();
//
//    }
//
//    public MediaController(Context context, boolean useFastForward, boolean disableProgressBar) {
//        this(context);
//        mDisableProgress = disableProgressBar;
//    }
//
//
//    public MediaController(Context context, boolean useFastForward) {
//        this(context);
//    }
//
//    public void refreshProgress() {
//        mProgress.setProgress(1000);
//        mCurrentTime.setText(CommonUtils.generateTime(mDuration));
//    }
//
//    public void setOnClickSpeedAdjustListener(OnClickSpeedAdjustListener listener) {
//        mOnClickSpeedAdjustListener = listener;
//    }
//
//    private boolean initController() {
//        mAM = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
//        return true;
//    }
//
//    @Override
//    public void onFinishInflate() {
//        if (mRoot != null)
//            initControllerView(mRoot);
//        super.onFinishInflate();
//    }
//
//
//    private void initFloatingWindow() {
//        mWindow = new PopupWindow(videoTextureView);
//        mWindow.setFocusable(false);
//        mWindow.setBackgroundDrawable(null);
//        mWindow.setOutsideTouchable(true);
//        mAnimStyle = android.R.style.Animation;
//    }
//
//    /**
//     * Create the view that holds the widgets that control playback. Derived
//     * classes can override this to create their own.
//     *
//     * @return The controller view.
//     */
//    protected View makeControllerView() {
//        return ((LayoutInflater) mContext
//                .getSystemService(Context.LAYOUT_INFLATER_SERVICE)).inflate(R.layout.layout_bottom, this);
//    }
//
//    private void initControllerView(View v) {
//        // By default these are hidden.
//        mPauseButton = (ImageView) v.findViewById(R.id.iv_start);
//        if (mPauseButton != null) {
//            mPauseButton.requestFocus();
//            mPauseButton.setOnClickListener(mPauseListener);
//        }
//        ImageView mFullScreen = (ImageView) v.findViewById(R.id.fullscreen);
//        mFullScreen.setOnClickListener(v1 -> onFullScreenListener.onFullScreen());
//
//        mProgress = (ProgressBar) v.findViewById(R.id.progress);
//        if (mProgress != null) {
//            if (mProgress instanceof SeekBar) {
//                seeker = (SeekBar) mProgress;
//                seeker.setOnSeekBarChangeListener(mSeekListener);
//                seeker.setThumbOffset(1);
//            }
//            mProgress.setMax(1000);
//            mProgress.setEnabled(!mDisableProgress);
//        }
//
//        mEndTime = (TextView) v.findViewById(R.id.total);
//        mCurrentTime = (TextView) v.findViewById(R.id.current);
//    }
//
//
//    /**
//     * Control the action when the seekbar dragged by user
//     *
//     * @param seekWhenDragging True the media will seek periodically
//     */
//    public void setInstantSeeking(boolean seekWhenDragging) {
//        mInstantSeeking = seekWhenDragging;
//    }
//
//    private void disableUnsupportedButtons() {
//        try {
//            if (mPauseButton != null && !mPlayer.canPause())
//                mPauseButton.setEnabled(false);
//        } catch (IncompatibleClassChangeError ex) {
//        }
//    }
//
//    /**
//     * <p>
//     * Change the animation style resource for this controller.
//     * </p>
//     *
//     * <p>
//     * If the controller is showing, calling this method will take effect only
//     * the next time the controller is shown.
//     * </p>
//     *
//     * @param animationStyle animation style to use when the controller appears and disappears.
//     *                       Set to -1 for the default animation, 0 for no animation,
//     *                       or a resource identifier for an explicit animation.
//     */
//    public void setAnimationStyle(int animationStyle) {
//        mAnimStyle = animationStyle;
//    }
//
//
//    public interface OnShownListener {
//        void onShown();
//    }
//
//    private OnShownListener mShownListener;
//
//    public void setOnShownListener(OnShownListener l) {
//        mShownListener = l;
//    }
//
//    public interface OnHiddenListener {
//        void onHidden();
//    }
//
//    public void setTitleView(View titleView) {
//        this.titleView = titleView;
//    }
//
//    public void hideTitle() {
//        if (titleView != null && requestedOrientation == ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE) {
//            titleView.setVisibility(View.GONE);
//        }
//    }
//
//
//    private OnHiddenListener mHiddenListener;
//
//    public void setOnHiddenListener(OnHiddenListener l) {
//        mHiddenListener = l;
//    }
//
//    @SuppressLint("HandlerLeak")
//    private Handler mHandler = new Handler() {
//        @Override
//        public void handleMessage(Message msg) {
//            long pos;
//            switch (msg.what) {
//                case FADE_OUT:
//                    hideController();
//                    hideTitle();
//                    break;
//                case SHOW_PROGRESS:
//                    if (!mPlayer.isPlaying()) {
//                        return;
//                    }
//                    pos = setProgress();
//                    if (pos == -1) {
//                        return;
//                    }
//                    if (!mDragging && mShowing) {
//                        msg = obtainMessage(SHOW_PROGRESS);
//                        sendMessageDelayed(msg, 50);
//                        updatePausePlay();
//                    }
//                    break;
//            }
//        }
//    };
//
//    private long setProgress() {
//        return setProgress(false);
//    }
//
//    public long setProgress(boolean reset) {
//        if (mPlayer == null || mDragging) {
//            return 0;
//        }
//        long position = 0L;
//        if (!reset) {
//            position = mPlayer.getCurrentPosition();
//        }
//        long duration = mPlayer.getDuration();
//        if (mProgress != null) {
//            if (duration > 0) {
//                long pos = 1000L * position / duration;
//                mProgress.setProgress((int) pos);
//            }
//            int percent = 0;
//            if (!reset) {
//                percent = mPlayer.getBufferPercentage();
//            }
//
//            mProgress.setSecondaryProgress(percent * 10);
//        }
//
//        mDuration = duration;
//
//        if (mEndTime != null)
//            mEndTime.setText(CommonUtils.generateTime(mDuration));
//        if (mCurrentTime != null)
//            mCurrentTime.setText(CommonUtils.generateTime(position));
//
//        return position;
//    }
//
//
//    @Override
//    public boolean onTouchEvent(MotionEvent event) {
//        if (event.getAction() == MotionEvent.ACTION_UP) {
//            showController(sDefaultTimeout);
//            return true;
//        }
//        return false;
//
//    }
//
////    @Override
////    public boolean onTrackballEvent(MotionEvent ev) {
//////        if (ev.getAction() == MotionEvent.ACTION_UP){
//////            show(sDefaultTimeout);
//////        }
//////
//////        return false;
////    }
//
//    @Override
//    public boolean dispatchKeyEvent(KeyEvent event) {
//        int keyCode = event.getKeyCode();
//        if (event.getRepeatCount() == 0
//                && (keyCode == KeyEvent.KEYCODE_HEADSETHOOK
//                || keyCode == KeyEvent.KEYCODE_MEDIA_PLAY_PAUSE || keyCode == KeyEvent.KEYCODE_SPACE)) {
//            doPauseResume();
//            showController(sDefaultTimeout);
//            if (mPauseButton != null)
//                mPauseButton.requestFocus();
//            return true;
//        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_STOP) {
//            if (mPlayer.isPlaying()) {
//                mPlayer.pause();
//                updatePausePlay();
//            }
//            return true;
//        } else if (keyCode == KeyEvent.KEYCODE_BACK
//                || keyCode == KeyEvent.KEYCODE_MENU) {
//            hideController();
//            return true;
//        } else {
//            showController(sDefaultTimeout);
//        }
//        return super.dispatchKeyEvent(event);
//    }
//
//    private OnClickListener mPauseListener = new OnClickListener() {
//        public void onClick(View v) {
//            if (mOnClickSpeedAdjustListener != null) {
//                mOnClickSpeedAdjustListener.onClickNormal();
//            }
//            doPauseResume();
//            showController(sDefaultTimeout);
//        }
//    };
//
//    public void updatePausePlay() {
//        if (mRoot == null || mPauseButton == null)
//            return;
//
//        if (mPlayer.isPlaying()) {
//            mPauseButton.setImageResource(R.mipmap.icon_play_pause);
//            startPlay.setImageResource(R.mipmap.icon_video_pause);
//        } else {
//            mPauseButton.setImageResource(R.mipmap.icon_play_start);
//            startPlay.setImageResource(R.mipmap.icon_video_play);
//        }
//
//    }
//
//    private void doPauseResume() {
//        if (mPlayer.isPlaying())
//            mPlayer.pause();
//        else
//            mPlayer.start();
//        updatePausePlay();
//    }
//
//    public void setDragging(boolean dragging) {
//        mDragging = dragging;
//    }
//
//    private SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener() {
//
//        public void onStartTrackingTouch(SeekBar bar) {
//            mDragging = true;
//            showController(3600000);
//            mHandler.removeMessages(SHOW_PROGRESS);
//            if (mInstantSeeking)
//                mAM.setStreamMute(AudioManager.STREAM_MUSIC, true);
//        }
//
//        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
//            if (!fromuser) {
//                return;
//            }
//            final long newposition = (long) (mDuration * progress) / 1000;
//            String time = CommonUtils.generateTime(newposition);
//            if (mInstantSeeking) {
//                mHandler.removeCallbacks(mLastSeekBarRunnable);
//                mLastSeekBarRunnable = () -> mPlayer.seekTo(newposition);
//                mHandler.postDelayed(mLastSeekBarRunnable, SEEK_TO_POST_DELAY_MILLIS);
//            }
//            if (onSeekBarListener != null) {
//                onSeekBarListener.onPosition(newposition * 100 / mDuration);
//            }
//            if (mCurrentTime != null)
//                mCurrentTime.setText(time);
//        }
//
//        public void onStopTrackingTouch(SeekBar bar) {
//            if (!mInstantSeeking)
//                mPlayer.seekTo(mDuration * bar.getProgress() / 1000);
//
//            showController(sDefaultTimeout);
//            mHandler.removeMessages(SHOW_PROGRESS);
//            mAM.setStreamMute(AudioManager.STREAM_MUSIC, false);
//            mDragging = false;
//            mHandler.sendEmptyMessageDelayed(SHOW_PROGRESS, 1000);
//        }
//    };
//
//    private OnClickListener mRewListener = new OnClickListener() {
//        public void onClick(View v) {
//            if (mOnClickSpeedAdjustListener != null) {
//                mOnClickSpeedAdjustListener.onClickSlower();
//            }
//            showController(sDefaultTimeout);
//        }
//    };
//
//    private OnClickListener mFfwdListener = new OnClickListener() {
//        public void onClick(View v) {
//            if (mOnClickSpeedAdjustListener != null) {
//                mOnClickSpeedAdjustListener.onClickFaster();
//            }
//            showController(sDefaultTimeout);
//        }
//    };
//
//    /**
//     * Set the view that acts as the anchor for the control view.
//     * <p>
//     * - This can for example be a VideoView, or your Activity's main view.
//     * - AudioPlayer has no anchor view, so the view parameter will be null.
//     *
//     * @param view The view to which to anchor the controller when it is visible.
//     */
//    @Override
//    public void setAnchorView(View view) {
//        mAnchor = view;
//        if (mAnchor == null) {
//            sDefaultTimeout = 0; // show forever
//        }
//        if (!mFromXml) {
//            removeAllViews();
//            mRoot = makeControllerView();
//            mWindow.setContentView(mRoot);
//            mWindow.setWidth(LayoutParams.MATCH_PARENT);
//            mWindow.setHeight(LayoutParams.WRAP_CONTENT);
//        }
//        initControllerView(mRoot);
//    }
//
//    @Override
//    public void setMediaPlayer(MediaPlayerControl player) {
//        mPlayer = player;
//        updatePausePlay();
//    }
//
//    @Override
//    public void show() {
//        show(sDefaultTimeout);
//    }
//
//    public void keepShow(boolean keepShow) {
//        this.keepShow = keepShow;
//    }
//
//    public void showController() {
//        showController(sDefaultTimeout);
//    }
//
//    /**
//     * Show the controller on screen. It will go away automatically after
//     * 'timeout' milliseconds of inactivity.
//     *
//     * @param timeout The timeout in milliseconds. Use 0 to show the controller until hide() is called.
//     */
//    @Override
//    public void show(int timeout) {
//    }
//
//    public boolean isShow() {
//        return mShowing;
//    }
//
//    public void showController(int timeout) {
//        showController(timeout, false);
//    }
//
//    public void showController(boolean reset) {
//        showController(sDefaultTimeout, reset);
//    }
//
//    public void showController(int timeout, boolean reset) {
//        if (!isEnable) return;
//        if (!mShowing) {
//            if (mAnchor != null && mAnchor.getWindowToken() != null) {
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
//                    mAnchor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
//                }
//            }
//            if (mPauseButton != null)
//                mPauseButton.requestFocus();
//            disableUnsupportedButtons();
//
//            if (mFromXml) {
//                setVisibility(View.VISIBLE);
//            } else {
//                int[] location = new int[2];
//                videoTextureView.getLocationInWindow(location);
//                if (mAnchor != null) {
////                    mAnchor.getLocationOnScreen(location);
//                    Rect anchorRect = new Rect(location[0], location[1],
//                            location[0] + mAnchor.getWidth(), location[1]
//                            + mAnchor.getHeight());
//
//                    mWindow.setAnimationStyle(mAnimStyle);
////                    mWindow.showAsDropDown(videoTextureView);
//                    mWindow.getContentView().measure(0, 0);
//                    mWindow.showAtLocation(videoTextureView, Gravity.NO_GRAVITY,
//                            0, videoTextureView.getHeight() - mWindow.getContentView().getMeasuredHeight());
//                    if (isShowStart) {
//                        startPlay.setVisibility(View.VISIBLE);
//                    } else {
//                        startPlay.setVisibility(View.GONE);
//                    }
//
//                } else {
//                    Rect anchorRect = new Rect(location[0], location[1],
//                            location[0] + mRoot.getWidth(), location[1]
//                            + mRoot.getHeight());
//
//                    mWindow.setAnimationStyle(mAnimStyle);
//                    mWindow.showAtLocation(mRoot, Gravity.BOTTOM,
//                            anchorRect.left, 0);
//                }
//            }
//            mShowing = true;
//            if (mShownListener != null)
//                mShownListener.onShown();
//        }
//        updatePausePlay();
//        if (!reset) {
//            mHandler.sendEmptyMessage(SHOW_PROGRESS);
//        }else {
//            mHandler.sendEmptyMessageDelayed(SHOW_PROGRESS,1000);
//        }
//
//
//        if (timeout != 0) {
//            mHandler.removeMessages(FADE_OUT);
//            mHandler.sendMessageDelayed(mHandler.obtainMessage(FADE_OUT),
//                    timeout);
//        }
//    }
//
//    public void seekTo(long newPosition) {
//        if (mInstantSeeking) {
//            mHandler.removeCallbacks(mLastSeekBarRunnable);
//            mLastSeekBarRunnable = () -> mPlayer.seekTo(newPosition);
//            mHandler.postDelayed(mLastSeekBarRunnable, SEEK_TO_POST_DELAY_MILLIS);
//        }
//        String time = CommonUtils.generateTime(newPosition);
//        if (mCurrentTime != null) {
//            mCurrentTime.setText(time);
//        }
//        seeker.setProgress((int) (newPosition * 1000 / mDuration));
//    }
//
//    @Override
//    public boolean isShowing() {
//        return mShowing;
//    }
//
//    public void setShowing(boolean isShowing) {
//        mShowing = isShowing;
//    }
//
//    public void setStartButton(ImageView ivStartPlay) {
//        startPlay = ivStartPlay;
//    }
//
//
//    @Override
//    public void hide() {
//    }
//
//    public void hideController() {
//        if (keepShow) {
//            return;
//        }
//        if (mShowing) {
//            if (mAnchor != null) {
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
//                    //mAnchor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);
//                }
//            }
//            try {
//                mHandler.removeMessages(SHOW_PROGRESS);
//                if (mFromXml) {
//                    setVisibility(View.INVISIBLE);
//                } else {
//                    mWindow.dismiss();
//                    startPlay.setVisibility(View.INVISIBLE);
//                }
//
//            } catch (IllegalArgumentException ex) {
//                L.INSTANCE.d(TAG, "MediaController already removed");
//            }
//            mShowing = false;
//            if (mHiddenListener != null)
//                mHiddenListener.onHidden();
//        }
//    }
//
//    @Override
//    public void setEnabled(boolean enabled) {
//        if (mPauseButton != null) {
//            mPauseButton.setEnabled(enabled);
//        }
//        if (mProgress != null && !mDisableProgress)
//            mProgress.setEnabled(enabled);
//        disableUnsupportedButtons();
//        super.setEnabled(enabled);
//    }
//
//    public PopupWindow getWindow() {
//        return mWindow;
//    }
//
//
//    public interface onFullScreenListener {
//        void onFullScreen();
//    }
//}
