package com.hupu.tv.player.app.widget

import android.content.Context
import android.os.CountDownTimer

import android.util.AttributeSet
import android.view.Gravity
import androidx.appcompat.widget.AppCompatTextView

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 获取验证码 倒计时View 语言需自己处理
 */
class TimerTextView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : AppCompatTextView(context, attrs, defStyleAttr) {
    private var downTimer: CountDownTimer? = null
    private fun initView(context: Context) {
        text = "获取验证码"
        gravity = Gravity.CENTER
    }

    private fun createTimer() {
        downTimer = object : CountDownTimer((COUNT_DOWN_TIME * 1000).toLong(), 1000) {
            override fun onTick(millisUntilFinished: Long) {
                //四舍五入 优化系统误差
                text = String.format("%d", Math.round(millisUntilFinished.toDouble() / 1000))
            }

            override fun onFinish() {
                finish()
            }
        }
    }

    fun start() {
        isEnabled = false
        if (downTimer != null) {
            downTimer!!.cancel()
        }
        createTimer()
        downTimer!!.start()
    }

    private fun finish() {
        text = "获取验证码"
        isEnabled = true
    }

    fun cancel() {
        if (downTimer != null) downTimer!!.cancel()
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        cancel()
    }

    companion object {
        private const val COUNT_DOWN_TIME = 60
    }

    init {
        initView(context)
    }
}