package com.hupu.tv.player.app.widget.customIm;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

import com.hupu.tv.player.app.R;

/**
 * @author by Dell
 * @date on 2020/6/17
 * @describe 带边框的ImageView
 */
public class CustomCircleImageView extends AppCompatImageView {
    private final String TAG = "TAG.CustomView";

    /**
     * 边框画笔的颜色
     */
    private int frameColor;
    /**
     * 边框的宽度
     */
    private float frameWidth;

    private Paint mPaint = new Paint();

    public CustomCircleImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CustomCircleImageView);
        frameWidth = array.getDimension(R.styleable.CustomCircleImageView_frame_width, 6);
        frameColor = array.getColor(R.styleable.CustomCircleImageView_frame_color, Color.GREEN);
        array.recycle();
    }

    public void setFrameColor(int frameColor) {
        this.frameColor = frameColor;
        invalidate();
    }

    public void setFrameWidth(float frameWidth) {
        this.frameWidth = frameWidth;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        mPaint.setAntiAlias(true);
        mPaint.setDither(true);
        //这里的颜色决定了边缘的颜色
        mPaint.setColor(frameColor);
        Drawable drawable = getDrawable();
        if (drawable == null) {
            return;
        }
        if (getWidth() == 0 || getHeight() == 0) {
            return;
        }
        Bitmap b = null;
        if (drawable instanceof BitmapDrawable) {
            b = ((BitmapDrawable) drawable).getBitmap();
        }
        if (drawable instanceof ColorDrawable) {
            DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
            b = convertToBitmap((ColorDrawable) drawable, displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        if (b == null) {
            return;
        }
        Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
        int w = getWidth();
        int h = getHeight();
        //圆形ImageView的半径为布局中的ImageView定义大小
        Bitmap roundBitmap = getCroppedBitmap(bitmap, w);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle(w / 2, h / 2, w / 2, mPaint);
        canvas.drawBitmap(roundBitmap, 0, 0, null);
    }


    public Bitmap getCroppedBitmap(Bitmap bmp, int radius) {
        Bitmap sbmp;
        if (bmp.getWidth() != radius || bmp.getHeight() != radius) {
            sbmp = Bitmap.createScaledBitmap(bmp, radius, radius, false);
        } else {
            sbmp = bmp;
        }
        Bitmap output = Bitmap.createBitmap(sbmp.getWidth(), sbmp.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        final Paint paint = new Paint();
        final Rect rect = new Rect(0, 0, sbmp.getWidth(), sbmp.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(Color.WHITE);
        //第三个参数减去的数值为白边的宽度.
        canvas.drawCircle(sbmp.getWidth() / 2, sbmp.getHeight() / 2, sbmp.getHeight() / 2 - frameWidth, paint);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(sbmp, rect, rect, paint);
        return output;
    }

    public static Bitmap convertToBitmap(ColorDrawable drawable,
                                         int widthPixels, int heightPixels) {
        Bitmap mutableBitmap = Bitmap.createBitmap(widthPixels,
                heightPixels, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(mutableBitmap);
        drawable.setBounds(0, 0, widthPixels, heightPixels);
        drawable.draw(canvas);
        return mutableBitmap;
    }
}
