package com.hupu.tv.player.app.widget.pickview.dialog;

import android.app.Dialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.Nullable;


import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.widget.pickview.DateTimePickerView;
import com.hupu.tv.player.app.widget.pickview.PickerViewDialog;

import java.util.Calendar;


public class DatePickerDialog extends BaseDialogFragment {
    private static boolean mIsBirthDay;
    private DateTimePickerView datePicker;

    public static DatePickerDialog newInstance(int type, ActionListener actionListener) {
        return BaseDialogFragment.newInstance(DatePickerDialog.class, type, actionListener);
    }

    public static DatePickerDialog newInstance(int type, ActionListener actionListener, boolean isBirthDay) {
        mIsBirthDay = isBirthDay;
        return BaseDialogFragment.newInstance(DatePickerDialog.class, type, actionListener);
    }

    @Override
    protected Dialog createDialog(Bundle savedInstanceState) {
        PickerViewDialog dialog = new PickerViewDialog(getActivity());
        dialog.setContentView(R.layout.dialog_date_picker);
        datePicker = dialog.findViewById(R.id.datePicker);
        if (mIsBirthDay) {
            datePicker.setEndDate(Calendar.getInstance());
        }

        attachActions(dialog.findViewById(R.id.done), dialog.findViewById(R.id.cancel));
        return dialog;
    }

    @Override
    protected View createView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_date_picker, container, false);
        datePicker = view.findViewById(R.id.datePicker);
        attachActions(view.findViewById(R.id.done), view.findViewById(R.id.cancel));
        return view;
    }

    public Calendar getSelectedDate() {
        return datePicker.getSelectedDate();
    }
}
