package com.softgarden.baselibrary

import android.app.Activity
import android.app.Application
import android.os.Bundle
import com.orhanobut.logger.AndroidLogAdapter
import com.orhanobut.logger.Logger
import com.scwang.smartrefresh.layout.SmartRefreshLayout
import com.scwang.smartrefresh.layout.constant.SpinnerStyle
import com.scwang.smartrefresh.layout.footer.ClassicsFooter
import com.scwang.smartrefresh.layout.header.ClassicsHeader
import com.softgarden.baselibrary.utils.ActivityManager


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
open class BaseApplication : Application() {
    companion object {
        var instance: BaseApplication? = null
            private set

        //static 代码段可以防止内存泄露
        init {
            //设置全局的Header构建器
            SmartRefreshLayout.setDefaultRefreshHeaderCreator { context, layout ->
                //layout.setPrimaryColorsId(android.R.color.transparent);//全局设置主题颜色
                val header = ClassicsHeader(context)
                header.spinnerStyle = SpinnerStyle.Translate //指定为经典Header，默认是 贝塞尔雷达Header
                header.setDrawableSize(15f)
            }
            //设置全局的Footer构建器
            SmartRefreshLayout.setDefaultRefreshFooterCreator { context, layout -> //指定为经典Footer，默认是 BallPulseFooter
                ClassicsFooter(context).setSpinnerStyle(SpinnerStyle.Translate)
            }
        }
    }



    override fun onCreate() {
        super.onCreate()
        instance = this

        //内存泄漏检测
//        if (LeakCanary.isInAnalyzerProcess(this)) {
//            // This process is dedicated to LeakCanary for heap analysis.
//            // You should not init your app in this process.
//            return
//        }
//        refWatcher = if (BuildConfig.DEBUG) LeakCanary.install(this) else RefWatcher.DISABLED
        // mRefWatcher = RefWatcher.DISABLED;

        //屏幕适配
        //AutoSizeConfig.getInstance().setDesignWidthInDp(360).setDesignHeightInDp(640);
        Logger.addLogAdapter(AndroidLogAdapter()) //logger
        registerActivityLifecycle()
    }

    /**
     * 全局管理Activity
     */
    private fun registerActivityLifecycle() {
        registerActivityLifecycleCallbacks(object : ActivityLifecycleCallbacks {
            override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
                ActivityManager.Companion.instance.add(activity) //加入管理栈
            }

            override fun onActivityStarted(activity: Activity) {}
            override fun onActivityResumed(activity: Activity) {}
            override fun onActivityPaused(activity: Activity) {}
            override fun onActivityStopped(activity: Activity) {}
            override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {}
            override fun onActivityDestroyed(activity: Activity) {
                ActivityManager.Companion.instance.remove(activity) //移除管理栈
//                refWatcher!!.watch(activity)
            }
        })
    }
}