package com.softgarden.baselibrary.base

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.content.res.TypedArray
import android.os.Build
import android.os.Bundle

import android.text.TextUtils
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.app.AppCompatDelegate
import com.kongzue.dialog.util.BaseDialog
import com.kongzue.dialog.v3.TipDialog
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.BuildConfig
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.dialog.LoadingDialog
import com.softgarden.baselibrary.utils.BaseSPManager
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.LanguageUtil
import com.softgarden.baselibrary.utils.ToastUtil
import java.util.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class BaseDelegate(var activity: Activity) {
    protected var mLanguage //语言
            : Locale? = null

    //    protected boolean isNightMode;//是否夜间模式
    protected var mIsAdapterScreen = true //是否适配屏幕
    var mOrientationPortrait = true //是否强制竖屏默认开启,视频界面全屏播放就要设置false
    val context: Context
        get() = activity

    fun onCreate(savedInstanceState: Bundle?) {
        //语言切换 要在setContentView()前

//        mLanguage = BaseSPManager.getLanguage();
//        L.d("SP 语言=" + mLanguage.getLanguage() + "  " + mLanguage.getCountry());

//        changeLanguage(mLanguage, false);


        //日夜模式
//        isNightMode = BaseSPManager.isNightMode();
//        changeDayNightMode(isNightMode);

        //屏幕适配 已使用AutoSize
    }

    fun onStart() {}
    fun onResume() {
        checkScreenOrientation()
        //        checkDayNightMode();
//        checkLanguage();
    }

    fun onPause() {}
    fun onStop() {}
    fun onSaveInstanceState(outState: Bundle?) {}
    fun onDestroy() {}
    /***********************************  LoadingDialog start    */
    /**
     * 显示加载框
     */
    fun showProgressDialog() {
//        showLoading(activity, null)
//        WaitDialog.show(activity as AppCompatActivity,null)
        val waitDialog =TipDialog.showWait(activity as AppCompatActivity,null)
        waitDialog.backgroundResId = R.drawable.translate
    }

    /**
     * 显示加载框（带文字）
     */
    fun showProgressDialog(message: CharSequence?) {
        showLoading(activity, message)
    }

    /**
     * 隐藏加载框
     */
    fun hideProgressDialog() {
        WaitDialog.dismiss()
//        BaseDialog.unload()
    }

    private var mCount = 0
    private var mLoadingDialog: LoadingDialog? = null

    @Synchronized
    fun showLoading(activity: Activity?, message: CharSequence?) {
        if (mCount == 0) {
            mLoadingDialog = LoadingDialog(activity, message)
            mLoadingDialog!!.setOnCancelListener { mCount = 0 }
            mLoadingDialog!!.show()
        }
        mCount++
    }

    @Synchronized
    fun dismissLoading() {
        if (mCount == 0) {
            return
        }
        mCount--
        if (mCount == 0 && mLoadingDialog != null) {
            mLoadingDialog!!.dismiss()
            mLoadingDialog = null
        }
    }

    fun clearLoading() {
        if (mLoadingDialog != null && mLoadingDialog!!.isShowing) {
            mCount = 0
            mLoadingDialog!!.dismiss()
            mLoadingDialog = null
        }
    }
    /*******************************  LoadingDialog end   */
    /**
     * 检查是否为竖屏
     */
    fun checkScreenOrientation() {
        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.O && isTranslucentOrFloating) {
            L.e("avoid calling setRequestedOrientation when Oreo.")
            return
        }
        if (mOrientationPortrait && activity.requestedOrientation != ActivityInfo.SCREEN_ORIENTATION_PORTRAIT) {
            //调用此方法会重新创建Activity导致onCreate()执行二次,
            // 最好在manifest中配置 android:screenOrientation="portrait"
            activity.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
        }
    }

    /**
     * 是否是透明的Activity
     *
     * @return
     */
    private val isTranslucentOrFloating: Boolean
        private get() {
            var isTranslucentOrFloating = false
            try {
                val styleableRes = Class.forName("com.android.internal.R\$styleable").getField("Window")[null] as IntArray
                val ta = activity.obtainStyledAttributes(styleableRes)
                val m = ActivityInfo::class.java.getMethod("isTranslucentOrFloating", TypedArray::class.java)
                m.isAccessible = true
                isTranslucentOrFloating = m.invoke(null, ta) as Boolean
                m.isAccessible = false
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return isTranslucentOrFloating
        }

    private fun fixOrientation(): Boolean {
        try {
            val field = Activity::class.java.getDeclaredField("mActivityInfo")
            field.isAccessible = true
            val o = field[this] as ActivityInfo
            o.screenOrientation = -1
            field.isAccessible = false
            return true
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return false
    }

    /**
     * 设置横屏竖屏
     *
     * @param mOrientationPortrait true 竖屏 false 横屏
     */
    fun setOrientationPortrait(mOrientationPortrait: Boolean) {
        this.mOrientationPortrait = mOrientationPortrait
    }

    /**
     * 配置变化时 （当前用于切换语言）
     *
     * @param newConfig
     */
    fun onConfigurationChanged(newConfig: Configuration?) {
        LanguageUtil.switchLanguage(activity, mLanguage)
    }

    /**
     * 7.0后适配语言
     *
     * @param newBase
     * @return
     */
    fun attachBaseContext(newBase: Context): Context? {
        mLanguage = BaseSPManager.Companion.language
        return LanguageUtil.attachBaseContext(newBase, mLanguage)
    }

    /**
     * 切换语言 (设置完后要重启Activity才生效 [.reload])
     *
     * @param language
     */
    fun changeLanguage(language: Locale, fromUser: Boolean) {
        LanguageUtil.switchLanguage(activity, language)
        BaseSPManager.Companion.language = language
        //改了之后就不会
        if (fromUser) {
            BaseSPManager.Companion.isFollowSystemLanguage = false
        }
    }

    /**
     * 检查语言
     */
    fun checkLanguage() {
        val language: Locale = BaseSPManager.Companion.language
        if (!isEqualsLanguage(mLanguage, language)) {
            mLanguage = language
            reload()
        }
    }

    /**
     * 重启Activity
     * 此方法会比 recreate() 效果更好
     */
    fun reload() {
        val intent = activity.intent
        activity.overridePendingTransition(0, 0)
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION)
        activity.finish()
        activity.overridePendingTransition(0, 0)
        activity.startActivity(intent)
        System.gc()
    }

    /**
     * 是否相同 二种语言 （语言和 国家都相同才算是相同）
     *
     * @param mLanguage
     * @param locale
     * @return
     */
    fun isEqualsLanguage(mLanguage: Locale?, locale: Locale): Boolean {
        return (TextUtils.equals(mLanguage!!.language, locale.language)
                && TextUtils.equals(mLanguage.country, locale.country))
    }

    /**
     * 检查日夜模式
     */
    private fun checkDayNightMode() {
        //检查日夜模式
//        boolean nightMode = BaseSPManager.isNightMode();
//        if (nightMode != isNightMode) {
//            isNightMode = nightMode;
//            reload();
//        }
    }

    /**
     * 切换日夜模式
     *
     *
     * 需要注意的两个地方，
     * 一是app或者activity引用的style需要是Theme.AppCompat.DayNight或者它的子style，
     * 二是调用getDelegate().setLocalNightMode()你的Activity必须是继承AppCompatActivity的。
     *
     * @param isNightMode
     */
    fun changeDayNightMode(isNightMode: Boolean) {
//        BaseSPManager.setNightMode(isNightMode);
        if (isNightMode) {
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES)
        } else {
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO)
        }
        //这是第二种方式
//        UiModeManager uiModeManager= (UiModeManager) getSystemService(Context.UI_MODE_SERVICE);
//        uiModeManager.setNightMode(UiModeManager.MODE_NIGHT_YES);
    }

    /**
     * 显示异常
     *
     * @param throwable
     */
    fun showError(throwable: Throwable) {
        ToastUtil.Companion.s(throwable.message)
        if (BuildConfig.DEBUG) throwable.printStackTrace()
    }

}