package com.softgarden.baselibrary.base

import android.R
import android.content.Context
import android.content.DialogInterface
import android.graphics.drawable.ColorDrawable
import android.os.Bundle

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.Window
import androidx.annotation.LayoutRes
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.FragmentManager
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.utils.InstanceUtil

import com.trello.rxlifecycle4.components.support.RxAppCompatDialogFragment
import java.lang.reflect.ParameterizedType

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe DialogFragment 基类
 */
abstract class BaseDialogFragment<P : IBasePresenter> : RxAppCompatDialogFragment(), IBaseDisplay {
    val TAG = javaClass.simpleName

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        dialog?.requestWindowFeature(Window.FEATURE_NO_TITLE)
        return inflater.inflate(layoutId, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        initContentView()

        initialize()
    }

    protected open fun initContentView() {
        if (!isAdded) return
        dialog?.window?.setBackgroundDrawable(ColorDrawable())
        setStyle(DialogFragment.STYLE_NO_INPUT, R.style.Theme_Light_NoTitleBar_Fullscreen)
    }

    open fun show(manager: FragmentManager?) {
        manager?.let {
            show(it, null)
        }

    }

    @get:LayoutRes
    abstract val layoutId: Int
    abstract fun initialize()

    @Synchronized
    override fun showProgressDialog() {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.showProgressDialog()
    }

    @Synchronized
    override fun showProgressDialog(message: CharSequence?) {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.showProgressDialog(message)
    }

    @Synchronized
    override fun hideProgressDialog() {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.hideProgressDialog()
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.showError(throwable,isConfigStatus)
    }

    override fun onApiException(e: ApiException) {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.onApiException(e)
    }
    override val ctx: Context?
        get() = activity

    override val baseActivity: BaseActivity<*>?
        get() {
            if (activity is BaseActivity<*>) {
                return activity as BaseActivity<*>?
            }
            throw RuntimeException("getActivity is not instanceof BaseActivity")
        }


    override fun onCancel(dialog: DialogInterface) {
        super.onCancel(dialog)
        if (onDismissListener != null) onDismissListener!!.onDismiss(this)
    }

    override fun onDismiss(dialog: DialogInterface) {
        super.onDismiss(dialog)
        if (onDismissListener != null) onDismissListener!!.onDismiss(this)
    }

    /**
     * 消失时触发
     *
     * @param onDismissListener
     */
    fun setOnDismissListener(onDismissListener: OnDismissListener?) {
        this.onDismissListener = onDismissListener
    }

    private var onDismissListener: OnDismissListener? = null

    interface OnDismissListener {
        fun onDismiss(dialog: DialogFragment?)
    }

    override fun onRequestFinish() {}

    /******************************************* MVP  */
    var presenter: P? = null
        private set

    protected fun initPresenter() {
        presenter = createPresenter()
        if (presenter != null) presenter?.attachView(this)
    }

    override fun onDestroyView() {
        super.onDestroyView()
        if (presenter != null) presenter?.detachView()
    }

    /**
     * 创建Presenter 此处已重写 需要时重写即可
     *
     * @return
     */
    fun createPresenter(): P? {
        if (this is IBaseDisplay
                && this.javaClass.genericSuperclass is ParameterizedType
                && (this.javaClass.genericSuperclass as ParameterizedType).actualTypeArguments.size > 0) {
            val mPresenterClass = (this.javaClass.genericSuperclass as ParameterizedType)
                    .actualTypeArguments[0] as Class<*> //获取Presenter的class
            return InstanceUtil.getInstance(mPresenterClass)
        }
        return null
    }
    /******************************************* MVP  */
}