package com.softgarden.baselibrary.base


import android.app.Activity
import android.content.Context
import android.content.Intent

import android.os.Bundle
import android.os.Handler
import android.os.Message
import android.view.*
import androidx.annotation.LayoutRes
import androidx.appcompat.app.AppCompatActivity
import com.google.gson.JsonParseException
import com.softgarden.baselibrary.BuildConfig
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.utils.InstanceUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.trello.rxlifecycle4.components.support.RxFragment

import java.lang.ref.WeakReference
import java.lang.reflect.ParameterizedType
import java.util.*
import java.net.ConnectException
import java.net.SocketTimeoutException
import java.net.UnknownHostException


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 *
 *
 * Fragment 基类  已实现以下功能
 *
 *
 * 1.显示/隐藏Loading弹框
 * 2.ButterKnife 绑定数据
 * 3.控制RxJava生命周期，防止内存泄漏
 * 4.MVP模式 参考 https://github.com/north2016/T-MVP
 * 需要时 可重写createPresenter() [BaseActivity.createPresenter]  并且使用泛型 <P extends BasePresenter> 为当前Presenter实例
</P> *
 */
abstract class BaseFragment<P : IBasePresenter?> : RxFragment(), IBaseDisplay {
    protected var mActivity: AppCompatActivity? = null
    protected var mContext: Context? = null

    var position = 0
    var title: String? = null


    override fun onAttach(context: Context) {
        super.onAttach(context)
        mActivity = context as AppCompatActivity
        mContext = context
        super.onAttach(context)
    }

    open fun onBackPress(): Boolean {
        return false;

    }


    override val ctx: Context?
        get() = mActivity

    override val baseFragment: BaseFragment<*>?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val mView = inflater.inflate(layoutId, container, false)
        return mView
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initPresenter()
        initialize()
    }

    open fun setStatus() {
        //5.0 全透明实现
        //getWindow.setStatusBarColor(Color.TRANSPARENT)
        val window: Window? = activity?.window
        window?.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)

    }


    /**
     * 切换日夜模式
     *
     * @param isNightMode
     */
    //    @Override
    //    public void changeDayNightMode(boolean isNightMode) {
    //        if (getActivity() instanceof BaseActivity)
    ////            ((BaseActivity) getActivity()).changeDayNightMode(isNightMode);
    //    }
    fun isEqualsLanguage(mLanguage: Locale?, locale: Locale?): Boolean {
        return if (activity is BaseActivity<*>) {
            (activity as BaseActivity<*>?)!!.isEqualsLanguage(mLanguage, locale!!)
        } else {
            false
        }
    }

    open fun onKeyDown(event: KeyEvent?): Boolean {
        return false
    }

    /**
     * 显示加载框
     */
    override fun showProgressDialog() {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.showProgressDialog()
    }

    /**
     * 显示加载框（带文字）
     */
    override fun showProgressDialog(message: CharSequence?) {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.showProgressDialog(message)
    }

    /**
     * 隐藏加载框
     */
    override fun hideProgressDialog() {
        if (activity is BaseActivity<*>) (activity as BaseActivity<*>?)!!.hideProgressDialog()
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        showFragmentError(throwable)
    }

    override fun onApiException(e: ApiException) {
        showCustomException(e)
        showErrorLayout()
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK && requestCode == REQUEST_LOGIN) {
            var eventId = 0
            if (data != null) eventId = data.getIntExtra(KEY_LOGIN_EVENT, 0)
            backFromLogin(eventId) //从登录界面返回  登录成功
        }
    }

    fun showFragmentError(t: Throwable) {
        when (t) {
            is ConnectException -> {
                ToastUtil.s(getString(R.string.base_connect_failed))

            }
            is UnknownHostException -> {
                ToastUtil.s(getString(R.string.base_request_serve_failed))

            }
            is SocketTimeoutException -> {
                ToastUtil.s(getString(R.string.base_socket_timeout))

            }
            is JsonParseException -> {
                ToastUtil.s(getString(R.string.base_parse_failed))

                t.printStackTrace()
            }
            is ApiException -> {
                //通用的Api异常处理
                onApiException(t)
            }
            else -> {
                showCustomException(t)
//                baseDelegate.showError(t)
            }
        }
        showErrorLayout()
    }

    open fun showErrorLayout() {

    }

    open fun showCustomException(t: Throwable) {
        ToastUtil.s(t.message)
        if (BuildConfig.DEBUG) t.printStackTrace()

    }


    /**
     * 登录成功 返回回调
     *
     * @param eventId 一般为点击View的id，可根据id判断接点击事件，从而继续操作流程
     */
    protected fun backFromLogin(eventId: Int) {}
//    override val baseActivity: BaseActivity<*>?
//        get() {
//            if (activity is BaseActivity<*>) {
//                return activity as BaseActivity<*>?
//            }
//            throw RuntimeException("getActivity is not instanceof BaseActivity")
//        }

    fun startActivity(cls: Class<out Activity?>?) {
        this.startActivity(Intent(activity, cls))
    }

    fun startActivityForResult(cls: Class<out Activity?>?, request: Int) {
        this.startActivityForResult(Intent(activity, cls), request)
    }

    override fun onRequestFinish() {}

    /*********************** MVP 参考 https://github.com/north2016/T-MVP  */
    var presenter: P? = null
        private set

    protected fun initPresenter() {
        presenter = createPresenter()
        presenter?.attachView(this)
    }

    override fun onDestroyView() {

        super.onDestroyView()
        presenter?.detachView()
    }


    /**
     * 创建Presenter 此处已重写 需要时重写即可
     */
    fun createPresenter(): P? {
        if (this is IBaseDisplay
            && this.javaClass.genericSuperclass is ParameterizedType
            && (this.javaClass.genericSuperclass as ParameterizedType).actualTypeArguments.size > 0
        ) {
            val mPresenterClass = (this.javaClass.genericSuperclass as ParameterizedType)
                .actualTypeArguments[0] as Class<*> //获取Presenter的class
            return InstanceUtil.getInstance(mPresenterClass)
        }
        return null
    }

    /*********************** MVP 参考 https://github.com/north2016/T-MVP  */
    @get:LayoutRes
    protected abstract val layoutId: Int
    protected abstract fun initialize()

    //    private class MyThread : Thread() {
//        private var mRunning = false
//        override fun run() {
//            mRunning = true
//            while (mRunning) {
//                SystemClock.sleep(1000)
//            }
//        }
//
//        fun close() {
//            mRunning = false
//        }
//    }
    class BaseHandler() : Handler() {
        private var mFragment: WeakReference<BaseFragment<*>>? = null

        constructor (fragment: BaseFragment<*>) : this() {
            mFragment = WeakReference(fragment)
        }


        override fun handleMessage(msg: Message?) {
            super.handleMessage(msg)
            val fragment: BaseFragment<*>? = mFragment?.get()
            if (fragment != null) {

            }
        }

    }

    companion object {
        /*** 通用的 用于传递数据的Key   */
        val KEY_DATA: String = BaseActivity.Companion.KEY_DATA
        val KEY_TITLE: String = BaseActivity.Companion.KEY_TITLE
        val KEY_TYPE: String = BaseActivity.Companion.KEY_TYPE
        val KEY_LOGIN_EVENT: String = BaseActivity.Companion.KEY_LOGIN_EVENT
        val REQUEST_LOGIN: Int = BaseActivity.Companion.REQUEST_LOGIN
        val REQUEST_CODE: Int = BaseActivity.Companion.REQUEST_CODE


    }
}