package com.softgarden.baselibrary.base

import android.graphics.Color
import android.util.Log
import android.view.View
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.gif.GifOptions
import com.bumptech.glide.request.RequestOptions
import com.softgarden.baselibrary.R
import me.bakumon.statuslayoutmanager.library.OnStatusChildClickListener
import me.bakumon.statuslayoutmanager.library.StatusLayoutManager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe Fragment基类 支持 预加载
 */
abstract class BaseLazyFragment<P : IBasePresenter?> : BaseFragment<P>() {
    /*** 修改要在 [.initialize] 之前 } */
    /**
     * 是否能预加载
     */
    var isCanLazyLoad = true

    /**
     * 第一次onResume中的调用onUserVisible避免操作与onFirstUserVisible操作重复
     */
    protected lateinit var mStatusLayoutManager: StatusLayoutManager
    protected var isFirstResume = true
    protected var isFirstVisible = true
    protected var isFirstInvisible = true
    protected var isPrepared = false
    override fun onResume() {
        super.onResume()
        if (isCanLazyLoad) {
//            if (isFirstResume) {
//                isFirstResume = false
//                return
//            }
            if (userVisibleHint) {
                onUserVisible()
            }
        }
    }

    override fun onPause() {
        super.onPause()
        if (isCanLazyLoad) {
            if (userVisibleHint) {
                onUserInvisible()
            }
        }
    }

    override fun setUserVisibleHint(isVisibleToUser: Boolean) {
        super.setUserVisibleHint(isVisibleToUser)
        if (isCanLazyLoad) {
            if (isVisibleToUser) {
                if (isFirstVisible) {
                    isFirstVisible = false
                    initPrepare()
                } else {
                    onUserVisible()
                }
            } else {
                if (isFirstInvisible) {
                    isFirstInvisible = false
                    onFirstUserInvisible()
                } else {
                    onUserInvisible()
                }
            }
        }
    }

    @Synchronized
    fun initPrepare() {
        if (isPrepared) {
            onFirstUserVisible()
        } else {
            isPrepared = true
        }
    }

    /**
     * 第一次fragment可见（进行初始化工作）
     */
    open fun onFirstUserVisible() {
        lazyLoad()
    }

    /**
     * fragment可见（切换回来或者onResume）
     */
    open fun onUserVisible() {}

    /**
     * 第一次fragment不可见（不建议在此处理事件）
     */
    fun onFirstUserInvisible() {}

    /**
     * fragment不可见（切换掉或者onPause）
     */
    open fun onUserInvisible() {}
    override fun initialize() {
        Log.e("fragment_initialize", this.javaClass.simpleName)
        initEventAndData()
        initPrepare()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        isPrepared = false
        isFirstVisible = true
        isFirstResume = true
        isFirstVisible = true
        isFirstInvisible = true
    }

    fun initStatusLayout(view: View) {
        mStatusLayoutManager = StatusLayoutManager.Builder(view)
            // 设置加载中布局
            .setLoadingLayout(View.inflate(requireContext(), R.layout.layout_loading, null).apply {
                Glide.with(context).asGif().load(R.mipmap.place_loading).apply(
                    RequestOptions()
                        .set(GifOptions.DECODE_FORMAT, DecodeFormat.PREFER_ARGB_8888)
                        .placeholder(0) //占位图
                        .error(0) //错误图
                        // .priority(Priority.HIGH)
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                ).into(findViewById(R.id.iv_loading))
            })
            // 设置空数据布局
            .setEmptyLayout(R.layout.layout_empty)
            // 设置出错布局
            .setErrorLayout(R.layout.layout_error)
            .setDefaultLayoutsBackgroundColor(mContext?.getColor(R.color.transparent)?:Color.parseColor("#00000000"))
            // 设置空数据布局重试按钮 ID
            .setEmptyClickViewID(R.id.bt_status_empty_click)
            // 设置出错布局重试按钮 ID
            .setErrorClickViewID(R.id.tv_error)

            .setOnStatusChildClickListener(object : OnStatusChildClickListener {
                override fun onEmptyChildClick(view: View?) {

                }

                override fun onErrorChildClick(view: View?) {
                    view?.postDelayed({ lazyLoad() }, 1000)
                    mStatusLayoutManager.showLoadingLayout()

                }

                override fun onCustomerChildClick(view: View?) {

                }
            })
            .build()
    }

    override fun showErrorLayout() {
        super.showErrorLayout()
        if (this::mStatusLayoutManager.isInitialized){
            mStatusLayoutManager.showErrorLayout()
        }
    }


    /**
     * 此方法不进行懒加载 只用于初始设置
     */
    abstract fun initEventAndData()

    //懒加载 一般用于网络请求
    public abstract fun lazyLoad()

    companion object {
        private val TAG = BaseLazyFragment::class.java.simpleName
    }
}