package com.softgarden.baselibrary.base

import android.content.Context
import com.softgarden.baselibrary.network.ApiException
import com.trello.rxlifecycle4.LifecycleTransformer


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 引入 IBaseDisplay mView  控制生命周期
 */
open class BasePresenter : IBasePresenter, IBaseDisplay {
    protected var mView: IBaseDisplay? = null
    override fun attachView(display: IBaseDisplay?) {
        mView = display
    }


    override fun detachView() {
        mView = null
    }

    override val ctx: Context?
        get() = mView?.ctx

    override val baseActivity: BaseActivity<*>?
        get() = mView?.baseActivity

    override val baseFragment: BaseFragment<*>?
        get() = mView?.baseFragment

    override fun showProgressDialog() {
        mView?.showProgressDialog()
    }

    override fun showProgressDialog(message: CharSequence?) {
        mView?.showProgressDialog(message)
    }

    override fun hideProgressDialog() {
        mView?.hideProgressDialog()
    }

    override fun showError(t: Throwable,isConfigStatus:Boolean) {
        mView?.showError(t,isConfigStatus)
    }

    override fun onApiException(e: ApiException) {
        mView?.onApiException(e)
    }

    override fun onRequestFinish() {
        mView?.onRequestFinish()
    }

    //    @Override
    //    public void changeDayNightMode(boolean isNightMode) {
    //        mView.changeDayNightMode(isNightMode);
    //    }
    override fun <T> bindToLifecycle(): LifecycleTransformer<T?>? {
        return mView?.bindToLifecycle()
    }
}